"""
script to view an image
"""
from __future__ import division, print_function, absolute_import
from argparse import ArgumentParser
import numpy as np
from PIL import Image


def user_inputs():
    """
    the user inputs
    :return string, path to natural photo to perturb
            string, path to perturbation file
            float, the amount of perturbation
            string, path to output file to save perturbed photo
    """
    parser = ArgumentParser()
    parser.add_argument('-x', type=str, required=True,
                        help='Path to natural photo to perturb')
    args = parser.parse_args()

    print('\n\nArguments')
    print('Natural photo path: {}'.format(args.x))
    print('\n\n')

    return args.x


def load_photo(fname):
    """
    load a photo
    :param fname: string, path to photo in txt file
    :return numpy 3D array of uint8 in {0, 1, ..., 255}
    """
    photo = np.genfromtxt(fname)
    return photo.astype('uint8').reshape((299, 299, 3), order='F')


def main():
    """the main method"""
    x_path = user_inputs()

    x = load_photo(x_path)
    Image.fromarray(x).show()


if __name__ == '__main__':
    main()
