/*
 * Decompiled with CFR 0.152.
 */
import com.aetrion.flickr.Flickr;
import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.REST;
import com.aetrion.flickr.RequestContext;
import com.aetrion.flickr.activity.ActivityInterface;
import com.aetrion.flickr.activity.Event;
import com.aetrion.flickr.activity.Item;
import com.aetrion.flickr.activity.ItemList;
import com.aetrion.flickr.auth.Auth;
import com.aetrion.flickr.auth.Permission;
import com.aetrion.flickr.util.IOUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Activity {
    static String apiKey;
    static String sharedSecret;
    Flickr f;
    REST rest;
    RequestContext requestContext;
    Properties properties = null;

    public Activity() throws ParserConfigurationException, IOException {
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream("/setup.properties.example");
            this.properties = new Properties();
            this.properties.load(in);
        }
        catch (Throwable throwable) {
            IOUtilities.close(in);
            throw throwable;
        }
        IOUtilities.close(in);
        this.f = new Flickr(this.properties.getProperty("apiKey"), this.properties.getProperty("secret"), new REST());
        this.requestContext = RequestContext.getRequestContext();
        Auth auth = new Auth();
        auth.setPermission(Permission.READ);
        auth.setToken(this.properties.getProperty("token"));
        this.requestContext.setAuth(auth);
        Flickr.debugRequest = false;
        Flickr.debugStream = false;
    }

    public void showActivity() throws FlickrException, IOException, SAXException {
        ActivityInterface iface = this.f.getActivityInterface();
        ItemList list = iface.userComments(10, 0);
        int j = 0;
        while (j < list.size()) {
            Item item = (Item)list.get(j);
            System.out.println("Item " + (j + 1) + "/" + list.size() + " type: " + item.getType());
            System.out.println("Item-id:       " + item.getId() + "\n");
            ArrayList events = (ArrayList)item.getEvents();
            int i = 0;
            while (i < events.size()) {
                System.out.println("Event " + (i + 1) + "/" + events.size() + " of Item " + (j + 1));
                System.out.println("Event-type: " + ((Event)events.get(i)).getType());
                System.out.println("User:       " + ((Event)events.get(i)).getUser());
                System.out.println("Username:   " + ((Event)events.get(i)).getUsername());
                System.out.println("Value:      " + ((Event)events.get(i)).getValue() + "\n");
                ++i;
            }
            ++j;
        }
        ActivityInterface iface2 = this.f.getActivityInterface();
        list = iface2.userPhotos(50, 0, "300d");
        int j2 = 0;
        while (j2 < list.size()) {
            Item item = (Item)list.get(j2);
            System.out.println("Item " + (j2 + 1) + "/" + list.size() + " type: " + item.getType());
            System.out.println("Item-id:       " + item.getId() + "\n");
            ArrayList events = (ArrayList)item.getEvents();
            int i = 0;
            while (i < events.size()) {
                System.out.println("Event " + (i + 1) + "/" + events.size() + " of Item " + (j2 + 1));
                System.out.println("Event-type: " + ((Event)events.get(i)).getType());
                if (((Event)events.get(i)).getType().equals("note")) {
                    System.out.println("Note-id:    " + ((Event)events.get(i)).getId());
                } else if (((Event)events.get(i)).getType().equals("comment")) {
                    System.out.println("Comment-id: " + ((Event)events.get(i)).getId());
                }
                System.out.println("User:       " + ((Event)events.get(i)).getUser());
                System.out.println("Username:   " + ((Event)events.get(i)).getUsername());
                System.out.println("Value:      " + ((Event)events.get(i)).getValue());
                System.out.println("Dateadded:  " + ((Event)events.get(i)).getDateadded() + "\n");
                ++i;
            }
            ++j2;
        }
    }

    public static void main(String[] args) {
        try {
            Activity t = new Activity();
            t.showActivity();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

