/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr;

import com.aetrion.flickr.Flickr;
import com.aetrion.flickr.RESTResponse;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.util.Base64;
import com.aetrion.flickr.util.DebugInputStream;
import com.aetrion.flickr.util.IOUtilities;
import com.aetrion.flickr.util.UrlUtilities;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class REST
extends Transport {
    private static final String UTF8 = "UTF-8";
    public static final String PATH = "/services/rest/";
    private boolean proxyAuth = false;
    private String proxyUser = "";
    private String proxyPassword = "";
    private DocumentBuilder builder;
    private static Object mutex = new Object();

    public REST() throws ParserConfigurationException {
        this.setTransportType("REST");
        this.setHost("api.flickr.com");
        this.setPath(PATH);
        this.setResponseClass(RESTResponse.class);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        this.builder = builderFactory.newDocumentBuilder();
    }

    public REST(String host) throws ParserConfigurationException {
        this();
        this.setHost(host);
    }

    public REST(String host, int port) throws ParserConfigurationException {
        this();
        this.setHost(host);
        this.setPort(port);
    }

    public void setProxy(String proxyHost, int proxyPort) {
        System.setProperty("http.proxySet", "true");
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", "" + proxyPort);
    }

    public void setProxy(String proxyHost, int proxyPort, String username, String password) {
        this.setProxy(proxyHost, proxyPort);
        this.proxyAuth = true;
        this.proxyUser = username;
        this.proxyPassword = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response get(String path, List parameters) throws IOException, SAXException {
        Object object;
        URL url = UrlUtilities.buildUrl(this.getHost(), this.getPort(), path, parameters);
        if (Flickr.debugRequest) {
            System.out.println("GET: " + url);
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        if (this.proxyAuth) {
            conn.setRequestProperty("Proxy-Authorization", "Basic " + this.getProxyCredentials());
        }
        conn.connect();
        InputStream in = null;
        try {
            in = Flickr.debugStream ? new DebugInputStream(conn.getInputStream(), System.out) : conn.getInputStream();
            Response response = null;
            object = mutex;
            synchronized (object) {
                Document document = this.builder.parse(in);
                response = (Response)this.responseClass.newInstance();
                response.parse(document);
            }
            object = response;
        }
        catch (IllegalAccessException e) {
            try {
                throw new RuntimeException(e);
                catch (InstantiationException e2) {
                    throw new RuntimeException(e2);
                }
            }
            catch (Throwable throwable) {
                IOUtilities.close(in);
                throw throwable;
            }
        }
        IOUtilities.close(in);
        return object;
    }

    /*
     * Exception decompiling
     */
    public Response post(String path, List parameters, boolean multipart) throws IOException, SAXException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[CATCHBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeParam(String name, Object value, DataOutputStream out, String boundary) throws IOException {
        if (value instanceof InputStream) {
            out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"image.jpg\";\r\n");
            out.writeBytes("Content-Type: image/jpeg\r\n\r\n");
            InputStream in = (InputStream)value;
            byte[] buf = new byte[512];
            int res = -1;
            while ((res = in.read(buf)) != -1) {
                out.write(buf);
            }
            out.writeBytes("\r\n--" + boundary + "\r\n");
        } else if (value instanceof byte[]) {
            out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"image.jpg\";\r\n");
            out.writeBytes("Content-Type: image/jpeg\r\n\r\n");
            out.write((byte[])value);
            out.writeBytes("\r\n--" + boundary + "\r\n");
        } else {
            out.writeBytes("Content-Disposition: form-data; name=\"" + name + "\"\r\n\r\n");
            out.write(((String)value).getBytes(UTF8));
            out.writeBytes("\r\n--" + boundary + "\r\n");
        }
    }

    public boolean isProxyAuth() {
        return this.proxyAuth;
    }

    public String getProxyCredentials() {
        return new String(Base64.encode((this.proxyUser + ":" + this.proxyPassword).getBytes()));
    }
}

