/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.contacts;

import java.io.Serializable;

public class OnlineStatus
implements Serializable {
    private static final long serialVersionUID = 12L;
    public static final int OFFLINE_TYPE = 0;
    public static final int AWAY_TYPE = 1;
    public static final int ONLINE_TYPE = 2;
    public static final int UNKNOWN_TYPE = 100;
    public static final OnlineStatus OFFLINE = new OnlineStatus(0);
    public static final OnlineStatus AWAY = new OnlineStatus(1);
    public static final OnlineStatus ONLINE = new OnlineStatus(2);
    public static final OnlineStatus UNKNOWN = new OnlineStatus(100);
    private int type;

    private OnlineStatus(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static OnlineStatus fromType(int type) {
        switch (type) {
            case 0: {
                return OFFLINE;
            }
            case 1: {
                return AWAY;
            }
            case 2: {
                return ONLINE;
            }
            case 100: {
                return UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Unsupported online type: " + type);
    }

    public static OnlineStatus fromType(String type) {
        if (type == null || "".equals(type)) {
            return UNKNOWN;
        }
        return OnlineStatus.fromType(Integer.parseInt(type));
    }
}

