/*
 * Decompiled with CFR 0.152.
 */
package com.aetrion.flickr.reflection;

import com.aetrion.flickr.FlickrException;
import com.aetrion.flickr.Parameter;
import com.aetrion.flickr.Response;
import com.aetrion.flickr.Transport;
import com.aetrion.flickr.auth.AuthUtilities;
import com.aetrion.flickr.reflection.Argument;
import com.aetrion.flickr.reflection.Error;
import com.aetrion.flickr.reflection.Method;
import com.aetrion.flickr.util.XMLUtilities;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReflectionInterface {
    public static final String METHOD_GET_METHOD_INFO = "flickr.reflection.getMethodInfo";
    public static final String METHOD_GET_METHODS = "flickr.reflection.getMethods";
    private String apiKey;
    private String sharedSecret;
    private Transport transport;

    public ReflectionInterface(String apiKey, String sharedSecret, Transport transport) {
        this.apiKey = apiKey;
        this.sharedSecret = sharedSecret;
        this.transport = transport;
    }

    public Method getMethodInfo(String methodName) throws IOException, SAXException, FlickrException {
        Element parent;
        Element child;
        Element parent2;
        Element child2;
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_GET_METHOD_INFO));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.add(new Parameter("method_name", methodName));
        parameters.add(new Parameter("api_sig", AuthUtilities.getSignature(this.sharedSecret, parameters)));
        Response response = this.transport.get(this.transport.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element methodElement = response.getPayload();
        Method method = new Method();
        method.setName(methodElement.getAttribute("name"));
        method.setNeedsLogin("1".equals(methodElement.getAttribute("needslogin")));
        method.setNeedsSigning("1".equals(methodElement.getAttribute("needssigning")));
        String requiredPermsStr = methodElement.getAttribute("requiredperms");
        if (requiredPermsStr != null && requiredPermsStr.length() > 0) {
            try {
                int perms = Integer.parseInt(requiredPermsStr);
                method.setRequiredPerms(perms);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        method.setDescription(XMLUtilities.getChildValue(methodElement, "description"));
        method.setResponse(XMLUtilities.getChildValue(methodElement, "response"));
        method.setExplanation(XMLUtilities.getChildValue(methodElement, "explanation"));
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        Element argumentsElement = XMLUtilities.getChild(methodElement, "arguments");
        if (argumentsElement == null && (child2 = XMLUtilities.getChild(parent2 = (Element)methodElement.getParentNode(), "arguments")) != null) {
            argumentsElement = child2;
        }
        NodeList argumentElements = argumentsElement.getElementsByTagName("argument");
        for (int i = 0; i < argumentElements.getLength(); ++i) {
            Argument argument = new Argument();
            Element argumentElement = (Element)argumentElements.item(i);
            argument.setName(argumentElement.getAttribute("name"));
            argument.setOptional("1".equals(argumentElement.getAttribute("optional")));
            argument.setDescription(XMLUtilities.getValue(argumentElement));
            arguments.add(argument);
        }
        method.setArguments(arguments);
        Element errorsElement = XMLUtilities.getChild(methodElement, "errors");
        if (errorsElement == null && (child = XMLUtilities.getChild(parent = (Element)methodElement.getParentNode(), "errors")) != null) {
            errorsElement = child;
        }
        ArrayList<Error> errors = new ArrayList<Error>();
        NodeList errorElements = errorsElement.getElementsByTagName("error");
        for (int i = 0; i < errorElements.getLength(); ++i) {
            Error error = new Error();
            Element errorElement = (Element)errorElements.item(i);
            error.setCode(errorElement.getAttribute("code"));
            error.setMessage(errorElement.getAttribute("message"));
            error.setExplaination(XMLUtilities.getValue(errorElement));
            errors.add(error);
        }
        method.setErrors(errors);
        return method;
    }

    public Collection getMethods() throws IOException, SAXException, FlickrException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(new Parameter("method", METHOD_GET_METHODS));
        parameters.add(new Parameter("api_key", this.apiKey));
        parameters.add(new Parameter("api_sig", AuthUtilities.getSignature(this.sharedSecret, parameters)));
        Response response = this.transport.get(this.transport.getPath(), parameters);
        if (response.isError()) {
            throw new FlickrException(response.getErrorCode(), response.getErrorMessage());
        }
        Element methodsElement = response.getPayload();
        ArrayList<String> methods = new ArrayList<String>();
        NodeList methodElements = methodsElement.getElementsByTagName("method");
        for (int i = 0; i < methodElements.getLength(); ++i) {
            Element methodElement = (Element)methodElements.item(i);
            methods.add(XMLUtilities.getValue(methodElement));
        }
        return methods;
    }
}

