/**
 * This class accesses the Flickr API and downloads the necessary images.
 * It does one search for source images based on the command line argument 
 * that it is given and a second search that is hard-coded to find natural
 * green training images.
 *  
 */
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import com.aetrion.flickr.Flickr;
import com.aetrion.flickr.REST;
import com.aetrion.flickr.photos.Photo;
import com.aetrion.flickr.photos.PhotoList;
import com.aetrion.flickr.photos.SearchParameters;

public class GetFlickrImages {

	public static void main(String[] args) {

		//Create Flickr Object
		try {
			Flickr  api = new Flickr(
					"b218a2b49301512d1222b685507372f6",
					"0bd712b1d199804a",
					new REST()
			);

			Flickr.debugStream = false;


			if(args ==  null)
				System.exit(0);


			System.out.println("Your search is : " + args[0]);

			//Set search Parameters
			SearchParameters param = new SearchParameters();
			param.setText(args[0]);
			param.setSort(SearchParameters.RELEVANCE);

			// Conduct Flickr search
			PhotoList results = 
				api.getPhotosInterface().search(param, 100, 0);

			// Download 100 images from search
			for(int i = 0; i < 100; i++){

				Photo p = (Photo) results.get(i);

				String url = "http://farm"+p.getFarm()+".staticflickr.com/"+
				p.getServer()+"/"+p.getId()+"_"+p.getSecret()+".jpg";

				if(url != null){
					System.out.println(i + " : " +url);
					BufferedImage img = api.getPhotosInterface().getImage(url);    		

					String name = "source/Flickr_" + (i+1) + ".jpg";
					try {
						// retrieve image
						File outputfile = new File(name);
						ImageIO.write(img, "jpg", outputfile);
					} catch (IOException e) {

					}
				}
			}


			// Search for 50 images to train our color algorithm
			System.out.println("Training with : (nature AND green) -portrait");
			SearchParameters param2 = new SearchParameters();
			param2.setText("(nature AND green) -portrait");
			param2.setSort(SearchParameters.RELEVANCE);

			PhotoList results2 = 
				api.getPhotosInterface().search(param2, 50, 0);


			for(int i = 0; i < 50; i++){

				Photo p = (Photo) results2.get(i);

				String url = "http://farm"+p.getFarm()+".staticflickr.com/"+
				p.getServer()+"/"+p.getId()+"_"+p.getSecret()+".jpg";

				if(url != null){
					System.out.println(i + " : " +url);
					BufferedImage img = api.getPhotosInterface().getImage(url);    		

					String name = "training/Flickr_" + (i+1) + ".jpg";
					try {
						// retrieve image
						File outputfile = new File(name);
						ImageIO.write(img, "jpg", outputfile);
					} catch (IOException e) {

					}
				}
			}
		} catch(Exception e) {
			e.printStackTrace();
		}
	}
}
