%{
Color Train trains our algorithm by finding the average green level
of the image given a trainingset directory of green/ natural images.
Returns a double value between 1 and 2 of the green value

Parameter:

trainingList: a list of the filenames of training images

%}


function [avgG] = colorTrain(trainingList)

dim = size(trainingList);

% Go to training directory
img = imread(strcat('training/',trainingList(1).name));

[totalGreen] = calcColor(img);

% step through all images and add up their green values
for i = 2 : dim(1)
    img = imread(strcat('training/',trainingList(i).name));
    [g] = calcColor(img);
    totalGreen = totalGreen + g;
end

% divide by the number of images to find mean value
avgG = totalGreen / dim(1);
