%{

This function compares two images based on their relative attributes of 
urban-ness and natural-ness. It returns an integer value of which is more
urban. RETURNS 1 if image 1 is more urban and REURNS 0 if image 2 is more
urban

Parameters:

cell1: the first image, contained in a cell
cell2: the second image contained in a cell
green: the trained green value

%}

function [compare] = compareImage(cell1, cell2, green)

% Line difference thrshold
threshold = 8;

% Extract images from cells
image1 = cell1{1};
image2 = cell2{1};

size1 = size(image1);
size2 = size(image2);

% Resize images if they are larger than 500 pixels
if(size1(2)>500)
image1 = imresize(image1, [NaN 500]);
end
if(size2(2)>500)
image2 = imresize(image2, [NaN 500]);
end

size1 = size(image1);
size2 = size(image2);

if(size1(1)>500)
image1 = imresize(image1, [500 NaN]);
end
if(size2(1)>500)
image2 = imresize(image2, [500 NaN]);
end

% Find vertical edge points
display('Finding Edgepoints...');
[loc1] = findedgepoints(image1);
[loc2] = findedgepoints(image2);

% Find and count lines in image 1
display('Finding Lines image 1...');
[numLines1 lines1] = countLines(loc1);

% Find and count lines in image 2
display('Finding Lines image 2...');
[numLines2 lines2] = countLines(loc2);

display('Comparing... Done.');
diffLines = abs(numLines1 - numLines2);


% calculate the AVERAGE GREEN COLOR for each image in a RANGE (1 <-> 2)
g1 = calcColor(image1);
g2 = calcColor(image2);

% MAIN COMPARISON ALG.

% If the difference in lines is greater than the threshold then compare
% images based on their numebr of lines
if diffLines > threshold
    % if im1 has more lines than im2
    if numLines1 > numLines2
        % if im1 is significanly more green than im2, im1 is more natural
        if g1 > g2+.1
            compare = 0;
         % if im1 is not significanly more green than im2, im2 is more natural
        else
            compare = 1;
            
        end
        return;
    % if im2 has more lines than im1
    else
        % if im2 is significanly more green than im1, im2 is more natural
        if g2 > g1+.1
            compare = 1;
         % if im2 is not significanly more green than im1, im2 is more natural
        else
            compare = 0;
        end
        return;
    end
% If the images have roughly the same number of lines, compare their 
% greennness with the trainign data
else
    % if im2 is closer to the trained green value it is more natural
    if abs(g1-green) > abs(g2-green)
        compare = 1;
        return;
    % else im2 is closer to the trained green value it is more natural
    else
        compare = 0;
        return;
    end
end

