%{

This function performs a liner regression on the given points.
It returns the number of lines found and a list of all their
slopes and y-intercepts

Parameters:

coords: The potential line coordinates

%}
function [output, l] = countLines(coords)

countLines = 0;

 %Threshold of 75 points to be considered a line
threshold = 75;
eq = zeros(1,3);
dim = size(coords);
l = zeros(1,2);

if dim(1) > 2
    %Test 10000 random pairs of points
    for i = 1 : 10000
        
        countPoints = 0;
        
        r1=0;
        r2=0;
        while(r1 == r2)
            r1 = randi(dim(1),1);
            r2 = randi(dim(1),1);
        end
        
        p1 = coords(r1,1:2);
        p2 = coords(r2,1:2);
        
        % Calculate line formula (Y-int and slope)
        slope = (p2(1)-p1(1))/(p2(2)-p1(2));
        b = (-p1(2)*slope) + p1(1);
        
        
        % terate along the given line
        for j = 1 : dim(1)
            
            if ((slope*coords(j,2) + b) - coords(j,1)) < 1  && ((slope*coords(j,2) + b) - coords(j,1)) > -1
                countPoints = countPoints + 1;
            end
        end
        %if the line contains enough points
        if countPoints - 2 > threshold
            a = 1;
            for j = 1 : countLines
                % Make sure line does not yet exist
                if(log(slope)-log(eq(j,1)) < .5 && log(slope)-log(eq(j,1)) > -.5)
                    %If line exists and this line has better correlation
                    %overwrite the old line
                    if (b - eq(j,2) < 3 && b - eq(j,2) > -3)
                        a = 0;
                        if(countPoints>eq(j,3))
                            l(j, 1:2) = p1;
                            l(j, 3:4) = p2;
                            eq(j, 1) = slope;
                            eq(j, 2) = b;
                            eq(j, 3) = countPoints;
                        end
                        
                    end
                end
            end
            % Add a line that is found. Store slope and y-int.
            if a == 1
                countLines = countLines + 1;
                l(countLines, 1:2) = p1;
                l(countLines, 3:4) = p2;
                eq(countLines, 1) = slope;
                eq(countLines, 2) = b;
                eq(countLines, 3) = countPoints;
            end
        end
    end
end

output = countLines;