%{
Does vertical line detection then makes an array of all points that are
weighted above .3 which will be used to try and detect lines.

Param:
img: the image to find edge points in

Return:
A 2xn array of points that lie on vertical edges

%}

function [loc] = findedgepoints(img)

img = im2double(img);

img = rgb2gray(img);

[DX DY] = gradient(img);

%make all values positive
DX = abs(DX);
DY = abs(DY);

% Weight vertical lines more and remove horizontal ones
edgeImg = -2* DY + 2 * DX;

dim = size(edgeImg);

points = zeros(dim(1),dim(2));

count = 0;
loc = ones(1,2);

for i = 1 : dim(1)
    for j = 1 : dim(2)
        
        if(edgeImg(i,j)) > .3
            count = count + 1; 
            loc(count,1:2) = [i,j];
            points(i,j) = 1;
        end
    end
end
