clear
close all
clc

sortNum = 0;
while sortNum < 1
sortNum = input('How many images would you like to include in the sort?: ');
end
%Use the java Flickr handler to download a set of images based on user text input

javaaddpath(pwd);
%load the jar file
javaclasspath('GetFlickrImages.jar')
flickrJava = GetFlickrImages;
%Get user input for text search
search = input('Please enter a search term:  ', 's');
%search = '(landscape, OR city, OR urban, OR natural) -portrait';
%perform the search
display('Downloading Flickr images...');
flickrJava.main(search);


display('Reading images and training algorithm...');
%Read in all the images to be sorted, downloaded from Flickr, to files
files = dir('source');
%Read in all the training images downloaded from Flickr to filesTrain
filesTrain = dir('training');

dirList = files(3:end);
trainingList = filesTrain(3:end);
num = size(dirList);

if sortNum > num(1)
   sortNum = num(1); 
end

imList = cell(1,sortNum);

%Calculate the average green of the training images to be used in the comparison
[avgGreen] = colorTrain(trainingList);

%Read in all the photos to be sorted
for i = 1 : sortNum
    im = imread(strcat('source/',dirList(i).name));
    imList(i) = {im};
end

%Perform the sorting using a merge sort algorithm
imList = mergeSort(imList, avgGreen);

clc
display('Exporting images...');
%{
Export all the n images to the 'sorted' directory. The files are sorted from most natural
Flickr_1.jpg to most urban (Flickr_n.jpg).
%}
for i = 1 : sortNum
    filename = strcat('sorted/Sort_',int2str(i),'.jpg');
    imwrite(imList{i}, filename, 'jpeg');
end


