%{

This function implements a merge sort to sort a list of images from most natural
to most urban. 

Parameters:
list: the list of images to be sorted in a cell array
green: the trained average green value

Return:
list: the sorted list of n images from most natural (1) to most urban (n).

%}

function list = mergeSort(list, green)
clc
s = size(list);
display('RUNNING MERGE SORT...');
display(strcat('Current array size:  ',int2str(s(2))));

if numel(list) <= 1
    return
else
	%Split the unsorted array into two smaller arrays
    middle = ceil(numel(list) / 2);
    left = list(1:middle);
    right = list(middle+1:end);
    
	%Perform a recursive sort on the split arrays
    left = mergeSort(left, green);
    right = mergeSort(right, green);

   
    if ~compareImage(left(end),right(1), green)
        list = [left right];
        return
    end
    
    display('COMBINING ARRAYS...');
    
    counter = 1;
	
    %Merge the split sorted arrays into a larger sorted array
    while (numel(left) > 0) && (numel(right) > 0)

        if(~compareImage(left(1),right(1), green)) 
            list(counter) = left(1);
            left(1) = [];
        else
            list(counter) = right(1);
            right(1) = [];
        end
        counter=counter+1;
    end
    
    if numel(left) > 0
        list(counter:end) = left;
    elseif numel(right) > 0
        list(counter:end) = right;
    end
end 

clc
display('RUNNING MERGE SORT...');
s = size(list);
display(strcat('Current array size:  ',int2str(s(2))));
end %mergeSort
