
#ifndef HRTIMER_H
#define HRTIMER_H

#if defined(__sparc)

// gethrtime already defined
#include <sys/time.h>

#elif defined(__i386) || defined(__tune_i686__) || defined(__x86_64__) || defined(__x86_64) || defined(__amd64)
 
#include <string.h>

typedef long long int hrtime_t;


#if defined(__cplusplus)
extern "C" {
#endif
  inline hrtime_t rdtsc() {
    unsigned long int lo, hi;
    __asm__ __volatile__ ("rdtsc" : "=a" (lo), "=d" (hi));
    return (hrtime_t) ((hi << 32) | lo);
  }
#if defined(__cplusplus)
}
#endif

#else // not sparc or x86
#error "HRTimer not supported on this architecture/OS"
#endif

class HRTimer {

public:
  HRTimer() {
#if defined(__linux) || defined(__linux__) || defined(linux)
    
    FILE* cpuinfo;
    char str[100];
    cpuinfo = fopen("/proc/cpuinfo","r");
    while(fgets(str,100,cpuinfo) != NULL){
      char cmp_str[8];
      strncpy(cmp_str, str, 7);
      cmp_str[7] = '\0';
      if(strcmp(cmp_str, "cpu MHz") == 0){
	double cpu_mhz;
	sscanf(str, "cpu MHz : %lf", &cpu_mhz);
	m_cpu_mhz = cpu_mhz;
	break;
      }
    }
    
    fclose( cpuinfo );
    
#endif
  }
  
  hrtime_t get_time_ns() {
#if defined(__sparc)
    return gethrtime();
#elif defined(__i386) || defined(__tune_i686__) || defined(__x86_64__) || defined(__x86_64) || defined(__amd64)
    return static_cast<hrtime_t>((static_cast<double>(rdtsc())*1.0e3)/m_cpu_mhz);
#endif
  }

private:
#if defined(__linux) || defined(__linux__) || defined(linux)
  double m_cpu_mhz;
#endif


};

#endif
