
#ifndef NBODYSIMULATOR_H
#define NBODYSIMULATOR_H

#include "NbodyTypes.h"

#define MINIMUM_MASS (3.3e23)           // units: kg  
                                        // this minimum is the mass of mercury
#define MAXIMUM_MASS (1.9891e30)        // units: kg
                                        // this maximum is the mass of the sun
#define MAXIMUM_VELOCITY 50000          // units: m/s  (this is per x-y component) 
                                        // I set the maxiumim to reflect the orbital velocity of mercury

class NbodySimulator
{
public:
  NbodySimulator(double universe_min_x, double universe_max_x,
                 double universe_min_y, double universe_max_y);
  virtual ~NbodySimulator();

  void populate(int num_bodies);
  virtual void simulate(int timesteps, double delta) = 0;

  void print( int matrix_size_x, int matrix_size_y );

protected:
  Body* m_bodies;
  int m_num_bodies;
  double m_universe_min_x,
    m_universe_max_x,
    m_universe_min_y,
    m_universe_max_y;
};

#endif
