
#ifndef QTREE_H
#define QTREE_H

#include <stdlib.h>

#include "NbodyTypes.h"

enum QTreeChildren {
  UPPER_LEFT_CHILD,
  UPPER_RIGHT_CHILD,
  LOWER_LEFT_CHILD,
  LOWER_RIGHT_CHILD
};

struct QTreeNode {
  struct QTreeNode* children[4];
  Rectangle region;
  int num_bodies;            // the number of indivisible bodies in this region
  PointMass point_mass;      // the apparent body mass and center of this region

  QTreeNode(Rectangle _region)
    : region(_region)
  {
    point_mass.center_of_mass.x = 0.0;
    point_mass.center_of_mass.y = 0.0;
    point_mass.mass = 0.0;
    num_bodies = 0;
    for (int i=0; i<4; i++) children[i] = NULL;
  }  
};

class QTree
{
public:
  QTree();
  ~QTree();

  void build(Body* bodies, int num_bodies, 
	     double min_x, double max_x, double min_y, double max_y);

  DoubleVector calculateForce(Body* body);

private:
  void insert(Body* b, QTreeNode* root);
  void deleteSubTree(QTreeNode* root);
  void recalculateMass(QTreeNode* root);
  DoubleVector calculateForceHelper(Body* body, QTreeNode* root);
  QTreeNode* m_root;
};


#endif
