#include <sys/errno.h>
#include <stdio.h>
#include <stdlib.h>
#include "Barrier.h"
#include "fatals.h"

PThreadLockCVBarrier::PThreadLockCVBarrier( int nThreads ) {
  if( nThreads < 1 ) {
    fatal("Invalid number of threads for barrier: %i\n",nThreads );
  }

  m_nThreads = nThreads;

  int ret;
  ret = pthread_mutex_init(&m_l_SyncLock, NULL);
  if(ret!=0) fatal("pthread_mutex_init failed at barrier creation.\n");

  ret = pthread_cond_init(&m_cv_SyncCV, NULL);
  if(ret!=0) fatal("pthread_cond_init failed at barrier creation.\n");

  m_nSyncCount = 0;
  
}

PThreadLockCVBarrier::~PThreadLockCVBarrier() {
  pthread_mutex_destroy(&m_l_SyncLock);
  pthread_cond_destroy(&m_cv_SyncCV);
}

void PThreadLockCVBarrier::Arrive() {
  pthread_mutex_lock(&m_l_SyncLock);
  m_nSyncCount++;
  if(m_nSyncCount == m_nThreads) {
    pthread_cond_broadcast(&m_cv_SyncCV);
    m_nSyncCount = 0;
  } else {
    pthread_cond_wait(&m_cv_SyncCV, &m_l_SyncLock);
  }

  pthread_mutex_unlock(&m_l_SyncLock);
  
}

