#include <iostream>
#include <assert.h>
#include <iomanip>
#include <vector>
#include <pthread.h>
#include "fatals.h"
#include "ProcMap.h"
#include "Barrier.h"
#include "CTree.h"
#include "Tests.h"
#include "Transactions.h"
#include "Stats.h"

#define SERIAL_TEST
#define PARALLEL_TEST
#define TRANSACTIONAL_TEST
#define THROUGHPUT_TEST

#ifdef TRANSACTIONAL_TEST
#ifndef PARALLEL_TEST
#error PARALLEL_TEST must be defined if TRANSACTIONAL_TEST is defined -- the parallel tests load the data structre.
#endif
#endif

using namespace std;

ProcessorMap * p_map = NULL;

class ThreadGoodies {
public:
  int myID;
  int nThreads;
  PThreadLockCVBarrier * p_barrier;

private:
};

volatile ConcurrentTree * p_concurrent_tree = NULL;

void* thread_target_function( void * p_threadGoodies ) {
  ThreadGoodies * p_myGoodies = (ThreadGoodies*) p_threadGoodies;
  ConcurrentTree * p_tree;

  p_map->BindToPhysicalCPU( p_map->LogicalToPhysical( p_myGoodies->myID ) );
  initSeed (p_myGoodies->myID);

#ifdef SERIAL_TEST
  p_myGoodies->p_barrier->Arrive();

  if( p_myGoodies->myID == 0 ) {
    cout << "Beginning single-threaded tree tests." << endl;
    if( testTreeSerial() ) {
      cout << "Passed single-threaded tests." << endl;
    } else {
      fatal("Failed single-theaded tests.\n");
    }

    cout << endl;
  }
#endif // #ifdef SERIAL_TEST

#ifdef PARALLEL_TEST
  if( p_myGoodies->myID == 0 ) {
    cout << "Beginning multi-threaded tree tests. (this part is not deterministic)" << endl;
    p_concurrent_tree = new ConcurrentTree( p_myGoodies->nThreads );
  }
  p_myGoodies->p_barrier->Arrive();

  p_tree = (ConcurrentTree*) p_concurrent_tree;
  if( testTreeParallel( p_tree, p_myGoodies->myID, p_myGoodies->nThreads, *p_myGoodies->p_barrier ) ) {
    if( p_myGoodies->myID == 0 ) {
      cout << "Passed multi-threaded tests." << endl;
    }
  } else {
    fatal("Failed parallel tests -- exit initiated by thread %i\n", p_myGoodies->myID );
  }

#endif // #ifdef PARALLEL_TEST
#ifdef TRANSACTIONAL_TEST
  
  if( p_myGoodies->myID == 0 ) {
    clearStats();
    cout << "Beginning Transactional Torture Tests. " << endl;
  }

  p_myGoodies->p_barrier->Arrive();

  p_tree = (ConcurrentTree*) p_concurrent_tree;
  if( testTreeTransactional( p_tree, p_myGoodies->myID, p_myGoodies->nThreads, *p_myGoodies->p_barrier ) ) {
    if( p_myGoodies->myID == 0 ) {
      cout << "Passed Transactional tests." << endl << flush;;
    }
  } else {
    printStats();
    fatal("Failed Transactional tests -- exit initiated by thread %i\n", p_myGoodies->myID );
  }

  p_myGoodies->p_barrier->Arrive();
#endif // #ifdef TRANSACTIONAL_TEST
#ifdef PARALLEL_TEST
  if( p_myGoodies->myID == 0 ) {
    cout << "Transactional Torture Test Stats:" << endl;
    printStats( );
    cout << flush;
  }
#endif // #ifdef PARALLEL_TEST
#ifdef THROUGHPUT_TEST
  p_myGoodies->p_barrier->Arrive();
  if( p_myGoodies->myID == 0 ) {
    clearStats();
    p_concurrent_tree = new ConcurrentTree( p_myGoodies->nThreads );
  }

  p_myGoodies->p_barrier->Arrive();

  p_tree = (ConcurrentTree*) p_concurrent_tree;
  if( testTreeThroughput(  p_tree, p_myGoodies->myID, p_myGoodies->nThreads, *p_myGoodies->p_barrier ) ) {
    if( p_myGoodies->myID == 0 ) {
      cout << "Passed Throughput tests." << endl;
    }
  } else {
    printStats();
    fatal("Failed Throughput tests -- exit initiated by thread %i\n", p_myGoodies->myID );
  }
  p_myGoodies->p_barrier->Arrive();
  if( p_myGoodies->myID == 0 ) {
    cout << "Transactional Throughput Test Stats:" << endl;
    printStats( );
    cout << flush;
  }
#endif

  p_myGoodies->p_barrier->Arrive();
  return NULL;
}

int main( int argc, char * argv[] ) {

  p_map = new ProcessorMap();

  int procs =  p_map->NumberOfProcessors();
  cout << "This machine has " << procs << " processors online. Their numbers are:" << endl;
  cout << setw(20) << "Logical Processor #" << "  Physical Processor #" << endl;

  for( int i=0;i<procs;i++) {
    cout << setw(20) << i << setw(20) << p_map->LogicalToPhysical(i) << setw(0) << endl;
  }

  cout << endl;
  if( NUM_ELEMENTS % procs ) {
    fatal("Please select NUM_ELEMENTS(%i) to divide evenly among all processors\n", NUM_ELEMENTS);
  }

  if( SMALL_TRANSACTION_SIZE % 2 ) {
    fatal("SMALL_TRANSACTION_SIZE(%i) must be even.\n",SMALL_TRANSACTION_SIZE);
  }

  pthread_t* threads;
  pthread_attr_t attr;
  int thread_number;

  threads = new pthread_t[procs];
  vector<ThreadGoodies> thread_goodies;
  thread_goodies.resize( procs );
  pthread_attr_init(&attr);
  pthread_attr_setscope(&attr,PTHREAD_SCOPE_SYSTEM);
  pthread_mutex_init( &statslock, NULL );
  PThreadLockCVBarrier * barrier = new PThreadLockCVBarrier( procs );

  int seed = time(NULL);
  cout << "Random seed is: " << seed << endl;


  for(thread_number=0;thread_number<procs;thread_number++) {
    thread_goodies[thread_number].myID = thread_number;
    thread_goodies[thread_number].nThreads = procs;
    thread_goodies[thread_number].p_barrier = barrier;
    if(pthread_create(&threads[thread_number],&attr,thread_target_function, (void*) &thread_goodies[thread_number])) {
      fatal("Thread creation failed.\n");
    }    
  }

  for(thread_number=0;thread_number<procs;thread_number++) {
    if(pthread_join(threads[thread_number],NULL)) {
      fatal("Thread join failed.\n");
    }    
  }  

  delete [] threads;
  delete barrier;
  delete p_map;

  pthread_mutex_destroy( &statslock );

  return 0;
}

