
#ifndef _BARRIER_H_
#define _BARRIER_H_

#include <pthread.h>

#ifdef __cplusplus

/* C++ object-oriented barriers -- use Barrier.C */
class PThreadLockCVBarrier {
public:
  PThreadLockCVBarrier( int nThreads ); 
  ~PThreadLockCVBarrier();

  void Arrive();

private:
  int             m_nThreads;
  pthread_mutex_t m_l_SyncLock;
  pthread_cond_t  m_cv_SyncCV;
  volatile int    m_nSyncCount;
};

#else // #ifdef __cplusplus

/* C function-based barrier -- use Barrier.c */

void Barrier();
void PrepareBarrier(int nProcs);
void DestroyBarrier();

#endif // #ifdef __cplusplus

#endif

