/*

	Test to see if variable elimination proceedure
	returns the same answer as in David Page's CS731 notes.

	In this example, there are 6 nodes:
	
	 /C - E\
	A       F (bottom)
	 \B - D/
	
	The CPTs are initalized (see below).
	Node C has evidence (C = True)
	A query is run over node F.
*/

#include "BayesNet.h"
#include "stl.h"
#include <sstream>
#include <string>
using namespace std;

/** special ad-hoc class for Variable C 
 	(which has evidence, C = True, which is value 1) */
class EvidenceC : public Evidence { 
  public:
  	double operator()(int example, int value) {
		return (value==1) ? 1.0 : 0.0;
	}
};

int main() { 

	// define variables (6 boolean variables, A-F)
	enum VARS { A,B,C,D,E,F };
	const string boolean_names[] = { "F", "T" };
	Variable va("A", A, boolean_names, boolean_names+2);
	Variable vb("B", B, boolean_names, boolean_names+2);
	Variable vc("C", C, boolean_names, boolean_names+2);
	Variable vd("D", D, boolean_names, boolean_names+2);
	Variable ve("E", E, boolean_names, boolean_names+2);
	Variable vf("F", F, boolean_names, boolean_names+2);

	// define nodes
	Node a(va), b(vb), c(vc), d(vd), e(ve), f(vf);

	// set up network A -> C -> E -> F and A -> B -> D -> F
	BayesNet BN;

	BN.connect(&a, &b);		
	BN.connect(&a, &c);
	BN.connect(&b, &d);
	BN.connect(&c, &e);
	BN.connect(&d, &f);
	BN.connect(&e, &f);

	// set up CPDs (create table creates an empty table)
	CPT *a_cpt = BN.create_table(A);	a.cpd = a_cpt;
	CPT *b_cpt = BN.create_table(B);	b.cpd = b_cpt;
	CPT *c_cpt = BN.create_table(C);	c.cpd = c_cpt;
	CPT *d_cpt = BN.create_table(D);	d.cpd = d_cpt;
	CPT *e_cpt = BN.create_table(E);	e.cpd = e_cpt;
	CPT *f_cpt = BN.create_table(F);	f.cpd = f_cpt;

	const double A_TABLE[] = { .8, .2 };
	const double B_TABLE[] = { .7, .3,  .2, .8 };
	const double C_TABLE[] = { .4, .6,  .9, .1 };
	const double D_TABLE[] = { .3, .7,  .6, .4 }; 
	const double E_TABLE[] = { .1, .9,  .5, .5 };
	const double F_TABLE[] = { .1, .9, .6, .4, .7, .3, .9, .1 };

	// assign probabilities
	copy(A_TABLE, A_TABLE+a_cpt->total_size(), a_cpt->begin());
	copy(B_TABLE, B_TABLE+b_cpt->total_size(), b_cpt->begin());
	copy(C_TABLE, C_TABLE+c_cpt->total_size(), c_cpt->begin());
	copy(D_TABLE, D_TABLE+d_cpt->total_size(), d_cpt->begin());
	copy(E_TABLE, E_TABLE+e_cpt->total_size(), e_cpt->begin());
	copy(F_TABLE, F_TABLE+f_cpt->total_size(), f_cpt->begin());

	// node C has evidence (C = True), use struct above
	EvidenceC evidence_c;
	c.evidence = &evidence_c;

	// Test by printing out each CPT
	cout << "a.cpt:" << endl << *((CPT*)(a.cpd)) << endl;
	cout << "b.cpt:" << endl << *((CPT*)(b.cpd)) << endl;
	cout << "c.cpt:" << endl << *((CPT*)(c.cpd)) << endl;
	cout << "d.cpt:" << endl << *((CPT*)(d.cpd)) << endl;
	cout << "e.cpt:" << endl << *((CPT*)(e.cpd)) << endl;
	cout << "f.cpt:" << endl << *((CPT*)(f.cpd)) << endl;

	// Test example from notes by running a query on F:
	cout << "BN.query(F, 0):  " << (BN.query(F,0)) << endl;

	// clean up (all nodes' cpd pointers are new, returned from BayesNet::create_table)
	delete a.cpd, b.cpd, c.cpd, d.cpd, e.cpd, f.cpd;

	return 0;
}


