#!/bin/bash

FOLDS=10
PREFIXV="input/carbon-154/carbon-154"
PREFIXX="input/carbon-154/cfv/cfv"	# followed by .X.trainset

BASELINE=0
while [ ${BASELINE} -le 2 ]
do
	OUTPUT="input/carbon-154/cfv/baseline${BASELINE}.results"
	
	/bin/rm -f ${OUTPUT}
	touch ${OUTPUT}
	
	i=0
	while [ "$i" -lt ${FOLDS} ]
	do
		./grn -r ${PREFIXV}.roles -c ${PREFIXV}.conditions -x ${PREFIXX}.${i}.trainset -s ${PREFIXX}.${i}.trainset.states -t ${PREFIXX}.${i}.testset -B ${BASELINE} -m0 -v >> ${OUTPUT}
	
		let "i+=1"
	done

	cat ${OUTPUT} | /usr/bin/python sum.py >> ${OUTPUT}
	
	let "BASELINE+=1"
done
