#!/usr/bin/python
#
# print the sum results from a bunch of subtotals (say, from cross-fold-validation)
#
#
# INPUT:
#	N0 E0 SSE0 LP0
#	N1 E1 SSE1 LP1
#	...
#
# OUTPUT:
#	SUM(N) SUM(E) SUM(SSE) SUM(LP) (with percentages, etc.)
#	
import sys, os, string, math;

sum = [];
line = sys.stdin.readline();
while (line != ""):

	spline = string.split(line);
	if (sum == []):  sum = [0.0] * len(spline);

	for i in range(0,len(spline)):
		if (i >= len(sum)):
			sum = sum + [0.0];
		sum[i] = sum[i] + float(spline[i]);

	line = sys.stdin.readline();

N = sum[0];
E = sum[1];
SSE = sum[2];
LP = sum[3];

print "N="+str(N),  "Error="+str(E)+" ("+str(100.0*(E/N))+"%)",  "SSE="+str(SSE),  "Log Probability="+str(LP)+" ("+str(math.exp(LP))+")";


