/**
 * Test Gaussian.h
 *
 *	creates Gnuplot script
 */


#include "gaussian.h"
#include "GMGenerator.h"
#include "mixture_constraints.h"
#include "OptionParser.h"

#include <stdlib.h>

#include <iostream>
#include <fstream>
#include <vector>

using namespace std;

int main(int argc, char **argv) { 

	int N;
	int D;
	
	int seed;

	double K, min_weight, min_stdev;

	const string pointsfile = "grn-tmp.GMGenerator.points.gnuplot";

	OptionParser parser("test GMGenerator.h"); 
	parser.add(Option("seed", 's', &seed, 6141976, "random number seed"));
	parser.add(Option("gaussians", 'N', &N, 3, "number of Gaussians in mixture"));
	parser.add(Option("data", 'D', &D, 100, "number of data points to generate for the estimation"));
	parser.add(Option("minsep", 'K', &K , 2.0, "number of standard distrbutions from which each Gaussian must be separated"));
	parser.add(Option("minweight", 'w', &min_weight, 0.1, "minimum weight of any Gaussian in the predicted mixture"));
	parser.add(Option("minstdev", 'v', &min_stdev, 0.1, "minimum standard distribution of any Gaussian in the predicted mixture"));

	vector<string> args = parser.parse(argc, argv, "mean1 ... meanN stdev1 ... stdevN weight1 ... weightN");

	srand(seed);

	GaussianMixture gm(N);
	int next = 0;
	for (int i=0; i<N; i++) { gm[i].mu = atof(args[next++].c_str()); }
	for (int i=0; i<N; i++) { gm[i].sigma = atof(args[next++].c_str()); }
	for (int i=0; i<N; i++) { gm[i].w = atof(args[next++].c_str()); }

	vector<double> data;
	for (int i=0; i<D; i++) { data.push_back( gm.generate() ); }

	GMGenerator gmg;	// use all default parameters
	GaussianMixture guess = gmg.generate(data.begin(), data.end(), 
	                                     GRN_GaussianMixtureConstraints(K, min_stdev, min_weight));

	// gnuplot output; plot randomly generated points
	ofstream fpoints_out(pointsfile.c_str());
	for (int i=0; i<D; i++) { 
		fpoints_out << data[i] << " " << 0.01 << endl;
	}
	fpoints_out.close();

	
	cout << GNUPLOT_GAUSSIAN_DEF << endl;
	cout << endl;
	cout << "plot " << "\"" << pointsfile << "\"," << gm.sum() << ", " << guess.sum() << ", " << guess.list() << endl;

	return 0;

}

