/*










*/

#include <string>
using namespace std;

#include "OptionParser.h"
#include "datafile.h"
#include "stl.h"


int main(int argc, char **argv) { 

	string roles_filename,conditions_filename,states_filename,values_filename,expression_filename,grn_filename;

	OptionParser parser("test datafile");
	
	parser.add(Option("roles", 'r', &roles_filename, "", "Roles file:  records are regulator-name regulatee-name Activator|Repressor priority"));
	
	parser.add(Option("conditions", 'c', &conditions_filename, "", "Conditions file:  records are condition-name possible-values-separated-by-whitespace"));
	
	parser.add(Option("states", 's', &states_filename, "", "Gene states as GaussianMixture:  records are gene-name number-of-states mean standard-deviation weight mean standard-deviation weight ..."));
	
	parser.add(Option("expression", 'x', &expression_filename, "", "Expression file:  header row has gene names, each record has array name followed by expression values"));
	
	parser.add(Option("values", 'v', &values_filename, "", "Values file:  header row has condition names, each record has array name followed by conditions values"));
	
	parser.add(Option("grn", 'g', &grn_filename, "", "Data file:  first line has number-of-arrays number-of-conditions number-of-genes, second line is conditions-names and genes-names (column header), rest of lines are array-name followed by variable values (conditions values or genes expression)"));

	parser.parse(argc, argv);


	if (roles_filename != "") { 
		cerr << "read roles..." << endl;
		list<Role> roles = read_roles(roles_filename, cerr);
		cerr << "ROLES:  " << roles << endl << endl;
	}

	if (conditions_filename != "") { 
		cerr << "read conditions..." << endl;
		list<pair<string,list<string> > > conditions = read_conditions(conditions_filename, cerr);
		cerr << "CONDITIONS:  " << conditions << endl << endl;
	}

	if (states_filename != "") { 
		cerr << "read states..." << endl;
		map<string,GaussianMixture> states = read_states(states_filename, cerr);
		cerr << "STATES:  " << states << endl << endl;
	}


	if (values_filename != "") { 
		vector<string> header;
		vector<pair<string, vector<string> > > values;
		cerr << "read values..." << endl;
		read_conditions_values(values_filename, header, values, cerr);
		cerr << "HEADER:  " << header << endl;
		cerr << "VALUES:  " << values << endl << endl;
	}


	if (expression_filename != "") { 
		vector<string> header;
		vector<pair<string, vector<double> > > expression;
		cerr << "read expression..." << endl;
		read_expression(expression_filename, header, expression, cerr);
		cerr << "HEADER:  " << header << endl;
		cerr << "EXPRESSION:  " << expression << endl << endl;
	}


	if (grn_filename != "") { 
		int N, C, G;
		vector<string> arrays;
		vector<string> conditions;
		vector<string> genes;
		vector<vector<string> > values;
		vector<vector<double> > expression;
		cerr << "read grn..." << endl;
		read_assay_data(grn_filename, N, C, G, arrays, conditions, genes, values, expression, cerr);
		cerr << "N, C, G:  " << N << ", " << C << ", " << G << endl;
		cerr << "ARRAYS:  " << arrays << endl;
		cerr << "CONDITIONS:  " << conditions<< endl;
		cerr << "GENES:  " << genes<< endl;
		cerr << "VALUES:  " << values<< endl;
		cerr << "EXPRESSION:  " << expression << endl << endl;
	}

	return 0;

} // main


