/**
 * Test Gaussian.h
 *
 *	creates Gnuplot script
 */


#include "gaussian.h"
#include "OptionParser.h"

#include <stdlib.h>

#include <iostream>
#include <fstream>
#include <vector>

using namespace std;

int main(int argc, char **argv) { 

	int N;
	double mean, stdev, mstdev;
	string fpoints, fcurve;

	const string g_pointsfile = "grn-tmp.Gaussian.points.gnuplot";
	const string g_curvefile = "grn-tmp.Gaussian.curve.gnuplot";
	const string gmm_pointsfile = "grn-tmp.GaussianMixture.points.gnuplot";
	const string gmm_curvefile = "grn-tmp.GaussianMixture.curve.gnuplot";

	OptionParser parser("test gaussian.h (Gaussian, GaussianMixture classes and related functions)");
	parser.add(Option("numpoints", 'n', &N, 100, "number of data points"));
	parser.add(Option("mean", 'u', &mean, 50.0, "mean (of single Gaussian test)"));
	parser.add(Option("stdev", 'd', &stdev, 10.0, "standard deviation (of single Gaussian test)"));
	parser.add(Option("mstdev", 'm', &mstdev, 10.0, "standard deviation of all Gaussians (mixture test)"));

	vector<string> smeans = parser.parse(argc, argv, "mean of each Gaussian (default 0, 25, 50)");

	if (smeans.empty()) { 
		smeans.push_back("0.0");
		smeans.push_back("25.0");
		smeans.push_back("50.0");
	}

	// ---- TEST Gaussian

	Gaussian g(mean, stdev);

	// plot the curve;
	cout << GNUPLOT_GAUSSIAN_DEF << endl;
	cout << endl;
	cout << "plot " << g << ", \"" << g_curvefile << "\", \"" << g_pointsfile << "\"" << endl;

	// plot randomly generated points
	ofstream fpoints_out(g_pointsfile.c_str());
	for (int i=0; i<N; i++) { 
		fpoints_out << g.generate() << " " << 0.01 << endl;
	}
	fpoints_out.close();

	// plot points weighted by probability
	ofstream fcurve_out(g_curvefile.c_str());
	for (int i=((int)(g.mu - 2.0*g.sigma)); i<=((int)(g.mu + 2.0*g.sigma)); i++) {
		// for each "unit" of distance within 2 std dev's...
		fcurve_out << i << " " << g.density(i) << endl;
	}


	// ---- TEST GaussianMixture

	vector<double> means;
	for (int i=0; i<smeans.size(); i++) { means.push_back(atof(smeans[i].c_str())); }

	GaussianMixture gm;

	for (int i=0; i<means.size(); i++) { 
		gm.push_back(Gaussian(means[i], stdev, 1.0/means.size()));	// uniform weight
	}
	std::sort(gm.begin(), gm.end()); // (by mean is default)

	// generate 
	ofstream pfout(gmm_pointsfile.c_str());
	for (int i=0; i<N; i++) { 
		pfout << gm.generate() << " 0.01" << endl;
	}
	pfout.close();

	// curve
	ofstream cfout(gmm_curvefile.c_str());
	for (int i=((int)(gm[0].mu-2.0*gm[0].sigma)); i<=((int)(gm[gm.size()-1].mu+2.0*gm[gm.size()-1].sigma)); i++) {
		cfout << i << " " << gm.density(i) << endl;
	}
	cfout.close();

	// echo gnuplot commands...
	cout << "plot " << gm.sum() << ", " << gm.list() << ", ";
	cout << "\"" << gmm_pointsfile << "\", \"" << gmm_curvefile << "\"" << endl;

	




	

	return 0;

}

