
#include "OptionParser.h"

#include <iostream>
#include <string>
#include <stdlib.h>
using namespace std;




int main(int argc, const char **argv) {

	// parameters
	string name, major;
	int age, luckynumber;
	double height, weight;
	bool male, cool;

	OptionParser parser("This program tests the OptionParser class.  It uses several parameters, \
	                 one of which (name) is required.  by giving a '-?' or '--help' \
					 as argument, the program should print a help description and \
					 exit.  By giving '--usage' as argument, the program should \
					 print a short usage description and exit.  Otherwise, the \
					 program should echo the values for each parameter, and the \
					 remaining arguments.");

	parser.add(Option("name", 'n', &name, "REQUIRED", "Person's name", true));
		// since name is required, the default value will be ignored.
	parser.add(Option("major", 'm', &major, "CS", "Person's major"));
	parser.add(Option("age", 'a', &age, 18, "Person's age"));
	parser.add(Option("ln", 'L', &luckynumber, 42, "Person's favorite number"));
	parser.add(Option("height", 'h', &height, 5.75, "Person's height (in feet)"));
	parser.add(Option("weight", 'w', &weight, 160.0, "Person's height (in pounds)"));
	parser.add(Option("female", 'f', &male, true, "Person is female (person is male if not supplied)"));
		// note that the *variable* is 'male', but the option is female, because the default (for male)
		//	is TRUE, so supplying the option makes it FALSE, which is the same as FEMALE in this case,
		//	so the description is given as 'female'
	parser.add(Option("cool", 'c', &cool, "Person is cool (person is uncool if not supplied)"));

	vector<string> args = parser.parse(argc, argv, "any remaining arguments...");

	cout << "name:  " << name << endl;
	cout << "\tmajor:  " << major << endl;
	cout << "\tage:  " << age << endl;
	cout << "\tlucky number:  " << luckynumber << endl;
	cout << "\theight:  " << height << endl;
	cout << "\tweight:  " << weight << endl;
	cout << "\t" << name << " is " << (male ? "male" : "female") << endl;
	cout << "\t" << name << " is " << (cool ? "cool" : "uncool") << endl;
	cout << endl;
	cout << "remaining arguments (there are " << args.size() << "): ";
	for (int i=0; i<args.size(); i++) { 
		cout << " " << args[i];
	}
	cout << endl;

	return 0;

}


