#include <iostream>
#include <iterator>
#include <vector>
#include <list>
#include <string>
using namespace std;

#include "stl.h"

#ifndef rnd
#define rnd() ((double)rand() / RAND_MAX)
#endif

// simple data structure
class Foo { 

  public:
  	
	int i;
	double d;

	Foo() { i = rand()%100;  d = 100*rnd(); }
	friend ostream& operator<<(ostream&, const Foo&);
};

ostream& operator<<(ostream &out, const Foo &foo) { 
	out << "Foo(" << foo.i << ", " << foo.d << ")";
	return out;
}



int main(int argc, char **argv) { 

	if (argc > 1) { srand(atoi(argv[1])); }

	cerr << "\n\n-- Test Collection Output" << endl;

		vector<int> vint(20);
		vector<double> vdouble(vint.size());
		for (int i=0; i<vint.size(); i++) { 
			vint[i] = i;
			vdouble[i] = ((double)i) + rnd();
		}
		cout << "vector of ints:     " << endl << vint << endl;
		cout << "vector of doubles:  " << endl << vdouble << endl;

		list<Foo> LFoo;
		for (int i=0; i<5; i++) { LFoo.push_back(Foo()); }
		cout << "list of Foo:        " << endl << LFoo << endl;

		map<string, int> simap;
		simap["Led Zeppelin II"] = 1969;
		simap["The Wall"] = 1979;
		simap["Thriller"] = 1982;
		simap["Aerosmith's Greatest Hits"] = 1995;
		cout << "map of string,int:  " << endl << simap << endl;
		
		pair<int,double> idpair;
		idpair.first = 42;
		idpair.second = 3.1416;
		cout << "pair of int,double: " << endl << idpair << endl;


	cerr << "\n\n-- Test randomize()" << endl;

		randomize(vdouble.begin()+10, vdouble.end());
		cout << "vector of doubles with last half randomized:     " 
			 << endl << vdouble << endl;
		randomize(vint.begin()+5, vint.begin()+15+1);
		// +1 because 'end' is excluded 
		cout << "vector of ints with elements 5 - 15 randomized:  " 
			 << endl << vint << endl;
		randomize(LFoo.begin(), LFoo.end());
		cout << "list of Foo with entire list randomized:         " 
			 << endl << LFoo << endl;

	cerr << "\n\n-- Test normalize()" << endl;

		vector<double> ndv;
		for (int i=0; i<5; i++) { ndv.push_back((double)i); }
		cout << "vector of doubles:  " << endl << ndv << endl;
		normalize(ndv);
		cout << "after normalize:    " << endl << ndv << endl;
		list<double> ndL;
		for (int i=0; i<5; i++) { ndL.push_back(2.0 * (double)i); }
		cout << "list of doubles:   " << endl << ndL << endl;
		normalize(ndL);
		cout << "after normalize:    " << endl << ndL << endl;

	cerr << "\n\n-- Tests complete." << endl;

	return 0;

}


