#include <iterator>
using namespace std;

#include "Branch.h"

/** Add a new motif to the disjunction and update bookkeeping data 
 *  Return false iff motif is already in list
 */
bool Branch::add(int motif, int S, const SMMap &smmap) {

	if (S > hits.size()) { hits.resize(S); }
	
	// add motif in sorted order
	for (list<int>::iterator d = motifs.begin(); ; ) {
		while (d != motifs.end()) {
			if (*d == motif) { return false; }
			if (*d > motif) { break; }
			d++;
		}
		motifs.insert(d, motif);
		break;
	}
	
	for (int s=0; s<S; s++) {

		for (list<pair<int, int> >::const_iterator i=smmap[s][motif].begin(); 
												   i!=smmap[s][motif].end(); i++) {

			if (!(strand & i->second)) { continue; } // skip motifs on wrong strand

			// keep positions in sorted order (quick access to most extreme cases):
			//	UPSTREAM (large magnitude negative numbers) ---> DOWNSTREAM (small mag. neg.)
			for (list<pair<int,int> >::iterator p=hits[s].begin(); ; p++) {
				// (looping through previous hits from most UPSTREAM to least UPSTREAM)
				
				if (p!=hits[s].end() && p->first == i->first) { break; } // same position on correct strand
				
				if (p==hits[s].end() || p->first > i->first) {	// smmap UPSTREAM of hit
					hits[s].insert(p, pair<int,int>(i->first, i->second));
					break; 
				}
			}

		} // next instance of new motif in sequence s

	} // next sequence

	// now hits is a list of (sequence, sorted-list-o-positions) pairs
	return true;
	
} // add(int motif, int S, const SMMap &smmap)



/** set this->strand and update bookeeping data (remove hits that do not match) */
void Branch::constrain_strand(int strand) {

	this->strand = strand;

	for (int s=0; s<hits.size(); s++) { 

		for (list<pair<int,int> >::iterator p=hits[s].begin(); p!=hits[s].end(); ) { 

			if (!(strand & p->second)) { 
				p = hits[s].erase(p);
			} else {
				p++;
			}
		}
	}
}

void Branch::reset(int S, const SMMap &smmap) { 
	list<int> stored_motifs = motifs; // copy
	hits.clear();
	motifs.clear();
	for (list<int>::const_iterator m=stored_motifs.begin(); m!=stored_motifs.end(); m++) { 
		this->add(*m, S, smmap);
	}
}

/** Remove one of the motifs and reset data */
void Branch::remove(int index, int S, const SMMap &smmap) { 
	list<int>::iterator itr = motifs.begin();
	for (int i=0; i<index; i++) { itr++; }
	motifs.erase(itr);
	this->reset(S, smmap);
}




void Branch::write(ostream &out) const { 
	out << motifs.size() << endl;
	std::copy(motifs.begin(), motifs.end(), ostream_iterator<int>(out, " "));
	out << endl;
	out << strand << endl;
}

void Branch::read(istream &in) {
	uint D;
	in >> D >> ws;
	for (uint d=0; d<D; d++) {
		int m;
		in >> m >> ws; 
		motifs.push_back(m);
	}
	in >> strand;

	return;
}






