#ifndef HYPOTHESIS_H
#define HYPOTHESIS_H

#include "definitions.h"
#include "Tree.h"
#include "Results.h"



struct Hypothesis {
	Tree *tree;
	Results *results;
	
	Hypothesis(Tree *t, Results *r) : tree(t), results(r) {
		#if DEBUG_MALLOC_CHECK
		hypothesis_alloc++;
		#endif
	}
	#if DEBUG_MALLOC_CHECK
	explicit Hypothesis(const Hypothesis &copy) 
		: tree(copy.tree), results(copy.results)
		{ hypothesis_alloc++; }
	#endif
	~Hypothesis() { 
		delete tree; delete results; 
		#if DEBUG_MALLOC_CHECK
		hypothesis_free++;
		#endif
	}
	bool operator==(const Hypothesis &h) { 
		// compare trees (assume equal trees => equal results)
		return (*(this->tree) == *(h.tree));
	}
};



#endif
