#ifndef RESULTS_H
#define RESULTS_H

#include <vector>
#include <list>
#include <map>
#include <iostream>
#include <fstream>
#include <stdlib.h>
#include <string>
#include <sstream>
#include <math.h>
#include <assert.h>
using namespace std;



#include "definitions.h"


/** 
 *	Summary statistics over a model, training/testing set
 *	Precision and Recall are pre-calculated constants
 */
struct Results {
	const double TP, FP, TN, FN;
	const double precision, recall;
	const double score;
	Results(int tp, int fp, int tn, int fn)	// really should take a pointer to a "score calculator"
		: TP((double)tp), FP((double)fp), TN((double)tn), FN((double)fn),
		  precision( tp+fp==0 ? 0.0 : ((double)tp / (tp+fp))  ),
		  recall   ( tp+fn==0 ? 0.0 : ((double)tp / (tp+fn))  ),
		  score( precision+recall==0.0 ? 0.0 : (2.0*precision*recall) / (precision+recall) )	// F1 score (04/29/2005)
		  //score( recall + (precision / 10000000.0))
	#if DEBUG_MALLOC_CHECK
	{ results_alloc++; }
	#else
	{ }
	#endif

	Results(double tp, double fp, double tn, double fn)
		: TP(tp), FP(fp), TN(tn), FN(fn),
		  precision( tp+fp==0 ? 0.0 : ((double)tp / (tp+fp))  ),
		  recall   ( tp+fn==0 ? 0.0 : ((double)tp / (tp+fn))  ),
		  score( precision+recall==0.0 ? 0.0 : (2.0*precision*recall) / (precision+recall) )	// F1 score (04/29/2005)
		  //score( recall + (precision / 10000000.0))
	#if DEBUG_MALLOC_CHECK
	{ results_alloc++; }
	#else
	{ }
	#endif


	#if DEBUG_MALLOC_CHECK
	Results(const Results &copy) 	// not explicit because of test(), ...
		: TP(copy.TP), FP(copy.FP), TN(copy.TN), FN(copy.FN),
		  precision(copy.precision), recall(copy.recall), score(copy.score)
		  { results_alloc++; }
	~Results() { results_free++; }
	#endif

};

#endif

