/*

	WSS.h

	Get the most out of your white space

	Used to tell if whitespace read (via '>>') from an istream
	contains end-of-file (defined as \n *OR* \r), and in general
	what whitespace characters are included.  (White space is 
	defined as ASCII characters [0-32].)

	'eol' is a count of \n and \r characters read.
	'ws' is an array of counts for all white space characters

		WSS myWSS;

		my_istream >> stuff >> myWSS;

		bool read_an_EOL = (myWSS.eol > 0);
		bool read_a_char_17 = (myWSS.ws[17] > 0);
		int read_how_many_tabs = (myWSS.ws[WSS::TAB]);

	(C) Noto, noto@cs.wisc.edu

*/


#ifndef __HEADER_WSS_H
#define __HEADER_WSS_H 0

#include <iostream>
using namespace std;

class WSS { 

  public:

	// my abbreviations for white space characters
	enum WHITE_SPACE {NUL,SOH,STX,ETX,EOT,ENQ,ACK,BEL,BS,TAB,LF,VT,FF,CR,SO,SI,
	                  DLE,DC1,DC2,DC3,DC4,NAK,SYN,ETB,CAN,EM,SUB,ESC,FS,GS,RS,US,
					  SPACE,NUM_WHITE_SPACE_CHARS};

  	int ws[NUM_WHITE_SPACE_CHARS];	// counts for all white space read
	int eol;	// special count of both newlines and carriage returns

	WSS() { reset(); }

	friend istream& operator>>(istream &in, WSS& wss);
		
	istream &scan(istream &in, WSS *wss) {
		
		char c;
		reset();
		while (in.good()) { 
			
			c = in.peek();
		
			if (c < NUM_WHITE_SPACE_CHARS ) { 
				// jeez, it's white space
				ws[(int)c]++;
				if (c=='\n' || c=='\r') { eol++; }
			} else {
				break;
			}
			c = in.get();	// read the white space char I just peeked at
		}
		return in;
	}

  private:
  	void reset() { 
		for (int i=0; i<NUM_WHITE_SPACE_CHARS; i++) { ws[i] = 0; }
		eol = 0;
	}

};


// this is the >> definition for the WSS function 
istream &operator>>(istream &in, WSS &wss) { return wss.scan(in, &wss); }

#endif
