

#include "classgrid.h"
#include <string>
#include <list>
#include <iomanip>
#include <sstream>

using namespace std;


string pad(const string &s, int L) { 

	string ans = s;
	for (int i=s.length(); i<L; i++) { 
		ans = " " + ans;
	}
	return ans;
}

string repeat(const string &s, int r) { 
	
	string ans = "";
	for (int i=0; i<r; i++) { 
		ans = ans + s;
	}
	return ans;
}

string grid(int TP, int FP, int TN, int FN) { 

	list<string> SL;
	SL.push_back(itos(TP));
	SL.push_back(itos(FP));
	SL.push_back(itos(TN));
	SL.push_back(itos(FN));
	SL.push_back(itos(TP+FN));	// first column total
	SL.push_back(itos(FP+TN));	// second

	int L = longest(SL.begin(), SL.end());

	string TPs = pad(itos(TP), L);
	string FPs = pad(itos(FP), L);
	string TNs = pad(itos(TN), L);
	string FNs = pad(itos(FN), L);

	string RT1 = pad(itos(TP+FP), L);	// first row total
	string RT2 = pad(itos(FN+TN), L);	
	string CT1 = pad(itos(TP+FN), L);	// first column total
	string CT2 = pad(itos(FP+TN), L);	
	string TTT = pad(itos(TP+FP+FN+TN), L);	// all 

	ostringstream oss;

	oss << "        Actual     " << endl;
	//oss << "       + " << repeat(" ", L) << " - " << repeat(" ", L) << endl;
	oss << "      " << repeat(" ", L-1) << "+" << "   " << repeat(" ", L-1) << "-" << endl;
	oss << "P    -" << repeat("-", L) << "- -" << repeat("-", L) << "-" << endl;
	oss << "r + | " << TPs << " | " << FPs << " | " << RT1 << endl;
	oss << "e   |-" << repeat("-", L) << "-+-" << repeat("-", L) << "-|" << endl;
	oss << "d - | " << FNs << " | " << TNs << " | " << RT2 << endl;
	oss << "     -" << repeat("-", L) << "- -" << repeat("-", L) << "-" << endl;
	oss << "      " << CT1 << "   " << CT2 << "   " << TTT << endl;

	return oss.str();
}

