
#ifndef CLASSGRID_H
#define CLASSGRID_H 0

#include <string>
#include <sstream>
using namespace std;


/** convert (ostream printable) data to a string */
template <typename _Printable>
string itos(const _Printable &i) { 
	ostringstream oss;
	oss << i;
	return oss.str();
}

/** return the length of the longest string */
template <typename _StrIterator>
int longest(_StrIterator begin, _StrIterator end) {
	int ans = -1;
	for (_StrIterator i=begin; i!=end; i++) { 
		if ( (int)(i->length()) > ans ) { ans = i->length(); }
	}
	return ans;
}

/** pad "s" with spaces in front so it's length is at least L */
string pad(const string &s, int L);

/** repeat "s" r times */
string repeat(const string &s, int r);

/** 
 *  print a actual/predicted grid of classification counts
 */
string grid(int TP, int FP, int TN, int FN);

#endif
