/***
 *
 * Some definitions for the CRM program
 *
 ******/


#ifndef CRM_TYPES_H
#define CRM_TYPES_H

#include <vector>
#include <list>
#include <map>
#include <iostream>
#include <fstream>
#include <stdlib.h>
#include <string>
#include <sstream>
#include <math.h>
#include <assert.h>
using namespace std;





// Add counters to constructors/destructors, make sure that
// I'm not leaking memory.
#define DEBUG_MALLOC_CHECK 0

#if DEBUG_MALLOC_CHECK
unsigned long branch_alloc = 0;
unsigned long branch_free = 0;
unsigned long results_alloc = 0;
unsigned long results_free = 0;
unsigned long tree_alloc = 0;
unsigned long tree_free = 0;
unsigned long hypothesis_alloc = 0;
unsigned long hypothesis_free = 0;
#endif




// if INFINITY is not defined (it should be in math.h)
#ifndef INFINITY
const double INFINITY = -log(0.0);
#endif

// KEEPING VISITED TREES:
// IF we've decided to RECORD where we've been, set this to TRUE
//	I think it's wise when K (beam width) is small to make sure 
//	you're getting the most bang from your search space.  If K
//	is large (then so is the number of explored solutions) and 
//	this may be too expensive
//
#define COLLECT_EXPLORED_TREES 0	// (05/03/2005:  I've never seen a repeated tree)

// Because of the hash function, good to use a prime
// perhaps one of:  1999 2999 4001 4999 10007 19997 30011 40009 49999 100003
#define TREEHASH_TABLE_SIZE 10007


const int TEMPLATE_STRAND=1, TRANSCRIBED_STRAND=2, EITHER_STRAND=3;
const string STRAND_STR[] = { "?", "tmpl", "tcx", "" };

const int EITHER_ORDER = 0, UPSTREAM_OF = -1, DOWNSTREAM_OF = 1;	// order constraints 

/** SMMap[sequence][motif] -> list of (position, strand) pairs */
typedef vector<vector<list<pair<int,int> > > > SMMap;

/**
 * Stats about a training set
 */
struct SetInfo { 
	int P;	// positive
	int S;	// size (positive + negative)
};

struct MotifInstance {
	int sid;
	int mid;
	int pos;
	int strand;
	MotifInstance(int s, int m, int p, int t) : sid(s), mid(m), pos(p), strand(t) { }
};


/** Motif instance data information */
struct MotifInstanceSet { 
	int M;	// number of motifs
	list<MotifInstance> data;
	SetInfo info;
};
	




#endif
