
#include "dna.h"

#include <iostream>
using namespace std;


/** Return TRUE iff given char is a DNA base */
bool base(char dna) { 
	return    dna=='A' || dna=='C' || dna=='G' || dna=='T'
	       || dna=='a' || dna=='c' || dna=='g' || dna=='t';
}


/** 
 * Return a string that is the DNA/IUPAC complement of the input string
 *	reverse = reverse the ordering of the sequence
 */
string revcomp(const string &dna, bool reverse) {

	string ans = dna;

	for (int i=0; i<dna.length(); i++) { 
		
		// find number for character
		int n = -1;
		     if (dna[i] == 'a') { n = 8; }	// 1000
		else if (dna[i] == 'c') { n = 4; }	// 0100
		else if (dna[i] == 'g') { n = 2; }	// 0010
		else if (dna[i] == 't') { n = 1; }	// 0001
		else {
			for (int p=0; p<IUPAC_L.length(); p++) { 
				if (IUPAC_L[p] == dna[i]) { 
					n = p;
					break;
				}
			}
			if (n == -1) { 
				for (int p=0; p<IUPAC_U.length(); p++) { 
					if (IUPAC_U[p] == dna[i]) { 
						n = p;
						break;
					}
				}
			}
			if (n == -1) { 
				cerr << "revcomp(const string&):  Illegal character in position " 
					 << i << " in sequence:" << endl << dna << endl;
				n = 0;	// just call it 'x'
			}
		}

		int r = 0;	// number of complement
		if (n & 8) { r |= 1; }	// 8==A, 1==T
		if (n & 4) { r |= 2; }	// 4==C, 2==G
		if (n & 2) { r |= 4; }	// ...
		if (n & 1) { r |= 8; }

		char x;
		// x = base(IUPAC_U[r]) ? IUPAC_U[r] : IUPAC_L[r];	// CAPITAL for AGCT, lower-case for IUPAC
		x = ('a' <= dna[i] && dna[i] <= 'z') ? IUPAC_L[r] : IUPAC_U[r];	// same base as sequence

		// set the appropriate character, depending on whether or not this is being reversed.
		if (reverse) { 
			ans[dna.length() - 1 - i] = x;
		} else {
			ans[i] = x;
		}

	}
	return ans;
}



