/*

	dna.h

	various "genetic" constants and utilities


*/ 

#ifndef DNA_H
#define DNA_H 0

#include <string>
using namespace std;

const char ALPHABET[] = "ACGT";
const char alphabet[] = "acgt";
#define ABLEN 4


/*
                  A  C  G  T
----------------+-----------
IUPAC[ 0] = 'X' | 0  0  0  0    ('X' also means 'N', but I'll use it for 0000 and 'N' for 1111)
IUPAC[ 1] = 'T' | 0  0  0  1
IUPAC[ 2] = 'G' | 0  0  1  0
IUPAC[ 3] = 'K' | 0  0  1  1
IUPAC[ 4] = 'C' | 0  1  0  0
IUPAC[ 5] = 'Y' | 0  1  0  1
IUPAC[ 6] = 'S' | 0  1  1  0
IUPAC[ 7] = 'B' | 0  1  1  1
IUPAC[ 8] = 'A' | 1  0  0  0
IUPAC[ 9] = 'W' | 1  0  0  1
IUPAC[10] = 'R' | 1  0  1  0
IUPAC[11] = 'D' | 1  0  1  1
IUPAC[12] = 'M' | 1  1  0  0
IUPAC[13] = 'H' | 1  1  0  1
IUPAC[14] = 'V' | 1  1  1  0
IUPAC[15] = 'N' | 1  1  1  1
*/


const string IUPAC_U = "XTGKCYSBAWRDMHVN";
const string IUPAC_L = "xtgkcysbawrdmhvn";

/** Return TRUE iff given char is a DNA base */
bool base(char dna);


/** 
 * Return a string that is the DNA/IUPAC complement of the input string
 *	reverse = reverse the ordering of the sequence
 */
string revcomp(const string &dna, bool reverse=true);



#endif
