/*

*/
#include <stdlib.h>
#include <math.h>
#include <vector>
#include <iostream>
#include <iomanip>
using namespace std;

#include "markov.h"
#include "WSS.h"

/** read in a 'markov model' data file, 
 *	return a vector of RMO arrays for Markov models of order 0, 1, ... N
 */
vector<vector<long double> > markov_read(istream &in) {

	vector<vector<long double> > ans;
	
	while (in.good()) { 

		string sequence;
		WSS wss;
		long double probability;

		in >> sequence >> wss;
		if (sequence[0] == ONE_LINE_COMMENT_CHAR) {
			// skip whole line
			while (!wss.eol) { in >> sequence >> wss; }
		} else {
			in >> probability >> ws;
			int order = sequence.length() - 1;
			if ((int)ans.size() <= order) { 
				for (int i=(int)ans.size(); i<=order; i++) { 
					ans.push_back(vector<long double>((unsigned int)(pow(((double)ABLEN), ((double)(i+1))))));
					std::fill(ans.back().begin(), ans.back().end(), 0.0);
				}
			}
			ans[order][markov_offset(sequence)] = probability;
		}
	}
	return ans;
}
			


/** writeout a 'markov model' data file */
void markov_write(ostream &out, const vector<vector<long double> > &data) { 

	for (int order=0; order<(int)data.size(); order++) { 
		out << ONE_LINE_COMMENT_CHAR << " order " << order << endl;
		for (int entry=0; entry<((int)(pow((double)ABLEN, (double)(order+1)))); entry++) {
			int rem = entry;
			int factor = (int)(pow((double)ABLEN, (double)(order)));
			for (int c=0; c<=order; c++) { 	// X-th order => print X+1 characters
				int nt = rem/factor;
				out << ALPHABET[nt];
				rem -= (nt * factor);
				factor /= ABLEN;
			}
			out << '\t' << setprecision(DEFAULT_PRECISION) 
				<< data[order][entry] 
				<< setprecision(-1) << endl;
		}
	}
}



/** Given a string, calculate the offset into the array for the
 *	appropriate order (len(string) - 1) 
 */
int markov_offset(const char *c, int N) {

	int ans = 0;
	int size = 1;
	
	for (int p=N-1; p>=0; p--) { 
		bool found = false;
		for (int a=0; a<ABLEN; a++) { 
			if (c[p] == ALPHABET[a] || c[p] == alphabet[a]) { 
				ans += a*size;
				found = true;
				break;
			}
		}
		if (!found) { return -1; }	// no place for illegal characters
		size *= ABLEN;
	}
	return ans;
}

int markov_offset(const string &sequence) {
	return markov_offset(sequence.c_str(), sequence.length());
}


/** Add counts to the markov model from a given sequence */
void markov_add(const char *c, int N, vector<vector<long double> > &markov_data, long double count = 1.0) {
	markov_data[N-1][markov_offset(c,N)] += count;
}
void markov_add(const string &sequence, vector<vector<long double> > &markov_data, long double count = 1.0) {
	markov_data[sequence.length()-1][markov_offset(sequence)] += count;
}

/** Normalize */
void markov_normalize(vector<vector<long double> > &mm, int order) {

	long double sum = 0.0;
	for (int i=0; i<(int)(mm[order].size()); i++) { 
		sum += mm[order][i];
	}
	for (int i=0; i<(int)(mm[order].size()); i++) { 
		mm[order][i] /= sum;
	}
	return;
}




	




