/*
	Functions for a homogeneous Markov model representing DNA sequence data
	                -----------                           ---
*/

#include <vector>
#include <iostream>
using namespace std;

#include "dna.h"

#define ONE_LINE_COMMENT_CHAR '#'
#define DEFAULT_PRECISION 50	// precision of long double values  in file


/** read in a 'markov model' data file, 
 *	return a vector of RMO arrays for Markov models of order 0, 1, ... N
 */
vector<vector<long double> > markov_read(istream &in);

/** writeout a 'markov model' data file */
void markov_write(ostream &out, const vector<vector<long double> > &data);

/** Given a string, calculate the offset into the array for the
 *	appropriate order (len(string) - 1) 
 *	return -1 in case of invalid offset (i.e. illegal character)
 */
int markov_offset(const string &sequence);
int markov_offset(const char *c, int N);

/** Add counts to the markov model from a given sequence */
void markov_add(const char *c, int N, vector<vector<long double> > &markov_data);
void markov_add(const string &sequence, vector<vector<long double> > &markov_data);


/** Normalize */
void markov_normalize(vector<vector<long double> > &markov_data, int order);
	

