

#include <stdlib.h>

#include <vector>
#include <iostream>
#include <fstream>
#include <sstream>
#include <string>
#include <iterator>
using namespace std;


#include "OptionParser.h"

bool process(int M, istream &in, ostream &out) { 

	if (in.good()) { 
		int s,m,p,t;
		string seq;
		in >> s >> m >> p >> t >> seq >> ws;
		if (m == M) { 
			out << "> sequence " << s << ", position " << p << endl
				<< seq << endl; 
		}
	} 
	return (in.good());
}


int main(int argc, const char **argv) { 

	int motif;

	OptionParser parser("Given a motif instance file (sid mid pos strand match),  print out the instances (sequence matches) of a given motif in FASTA format");
	
	parser.add(Option("motif", 'm', &motif, -1, "motif ID number", true));

	vector<string> args = parser.parse(argc, argv, "mif file");


	if (args.size()) {
		ifstream fin(args.front().c_str());
		if (fin) {
			while (process(motif,fin,cout));
			fin.close();
		} else {
			cerr << "Cannot open " << args.front() << endl;
		}
	} else {
		while (process(motif,cin,cout));
	}

	return 0;


}


