#!/usr/bin/python
#
#	translate a MIF file:
#
#		sequenceID  motifID  position  strand  comments....
#
#	to a FOIL program
#
#
#	Usage:
#
#		mif2foil.py S P N F < mif 
#
#	where:
#
#		S = sequences
#		P = positive sequences
#		N = CFV folds
#		F = fold to experiment on
#

import sys,string;

def trainset(s,N=10,F=0):
	return ((s % N) != F);

def testset(s,N=10,F=0):
	return (not(trainset(s,N,F)));

# translate line of MIF to a "contains" clause (and record values)
def mifline2contains(line,S,M,error=sys.stderr):
	if (line == ''):
		return None;
	else:
		split = string.split(line);
		s = int(split[0]);
		m = int(split[1]);
		p = int(split[2]);
		r = int(split[3]);
		if (r != 1 and r != 2):
			error.write("Illegal strand value (" + split[3] + ") in \"" + line + "\"\n");
		if ( s >= S ):  S=s+1;
		if ( m >= M ):  M=m+1;
		# if ( p <  P ):  P=p;
		return (S, M, "s" + str(s) + ",m" + str(m) + "," + str(p) + ",r" + str(r) + "\n");

# write foil program
def foil(out, S, P, M, contains, N=10, F=0):
	
	out.write("S:  ");
	for s in range(0,S-1):
		out.write("s" + str(s) + ", ");
	out.write("s" + str(S-1) + ".\n");

	out.write("M:  ");
	for m in range(0,M-1):
		out.write("*m" + str(m) + ", ");
	out.write("*m" + str(M-1) + ".\n");

	out.write("P:  continuous.\n");

	out.write("R:  *r1, *r2.\n");

	out.write("\n"); # -----------------------
	
	out.write("*contains(S,M,P,R)\n");
	for line in contains:
		out.write(line);

	out.write(".\n");
	out.write("CRM(S)\n");
	for s in range(0,P):
		if (trainset(s,N,F)):
			out.write("s" + str(s) + "\n");
	out.write(";\n");
	for s in range(P,S):
		if (trainset(s,N,F)):
			out.write("s" + str(s) + "\n");
	out.write(".\n");
	
	out.write("\n"); # ------------------------

	out.write("CRM\n");
	for s in range(0,S):
		if (testset(s,N,F)):
			out.write("s" + str(s) + " : ");
			if (s < P):
				out.write("+");
			else:
				out.write("-");
			out.write("\n");

# put it all together
def mif2foil(input, output, S, P, N, F):

	line = input.readline();
	M = 0;
	contains = [ ];	# clauses of 'contains' incl. newlines
	
	while (line != ''):
		(S,M,cline) = mifline2contains(line,S,M);
		contains = contains + [cline];
		line = input.readline();

	#sys.stderr.write(str(M) + " motifs.\n");
	
	foil(output, S, P, M, contains, N, F);	# weird default for P

def main():

	S = int(sys.argv[1]);
	P = int(sys.argv[2]);
	N = int(sys.argv[3]);
	F = int(sys.argv[4]);
	
	mif2foil(sys.stdin, sys.stdout, S, P, N, F);

main();
