#!/usr/bin/python
#
#	Translate a mif (motif instance file) to 
#	A 'gnuplot' schematic of motif locations
#
#	create a separate data file for each motif
#	
#
#
#

import sys,os,string;

true = TRUE = 1;
false = FALSE = 0;

TAB = '\t';
ENDL = '\n';

TMP = 1;
TCX = 2;
STRAND_OFFSET = 0.1;

PREFIX = "motif.";
EXTENSION = ".gnuplot";

def read(input, xmin, xmax, ymin, ymax):

	Mdict = { };
	
	line = input.readline();
	while (line != ""):
		
		split = string.split(line);
		S = int(split[0]) + 1;
		M = int(split[1]);
		P = int(split[2]);
		T = int(split[3]);

		Mdict[M] = TRUE;

		x = P;
		y = S;

		if (x < xmin):  xmin = x;
		if (x > xmax):  xmax = x;
		if (y < ymin):  ymin = y;
		if (y > ymax):  ymax = y;

		if (T == TMP):  y = y + STRAND_OFFSET;
		if (T == TCX):  y = y - STRAND_OFFSET;

		fout = open(PREFIX + str(M) + EXTENSION, "a");
		fout.write(str(x) + TAB + str(y) + ENDL);
		fout.close();
		
		line = input.readline();

	Mlist = [ ];
	for M in Mdict:
		Mlist = Mlist + [M];
	
	return (Mlist, xmin, xmax, ymin, ymax);

def main():
	
	xmin = -10;
	xmax = 0;
	ymin = 0;
	ymax = 1;

	Mlist = [];
	
	if (len(sys.argv) > 1):
		mifin = open(sys.argv[1], "r");
		(Mlist, xmin, xmax, ymin, ymax) = read(mifin, xmin, xmax, ymin, ymax);
		mifin.close();
	else:
		(Mlist, xmin, xmax, ymin, ymax) = read(sys.stdin, xmin, xmax, ymin, ymax);

	if (len(Mlist)):
		sys.stdout.write("plot ");
		sys.stdout.write("[" + str(xmin) + ":" + str(xmax) + "]");
		sys.stdout.write("[" + str(ymin) + ":" + str(ymax+1) + "]");
		sys.stdout.write(' "' + PREFIX + str(Mlist[0]) + EXTENSION + '"');
		for M in Mlist[1:]:
			sys.stdout.write(', "' + PREFIX + str(M) + EXTENSION + '"');
		sys.stdout.write(ENDL);	
	return;

main();
		
