#!/usr/bin/python
#
#	convert PSSM FILE:
#
#		consensus E-value site-1-A site-1-C  G  T   site-2-A ... site-N-T
#
#	to FASTA FILE:
#
#		> consensus (E-value: E-value)
#		consensus
#

import sys,string;
endl = '\n';

def pssm2fasta(input, output):
	line = input.readline();
	while (line != ''):
		split = string.split(line);
		consensus = split[0];
		E_value = split[1];
		output.write("> " + consensus + " (E-value: " + str(E_value) + ")" + endl);
		output.write(consensus + endl);
		line = input.readline();

def main():
	if (len(sys.argv) > 1):
		fin = open(sys.argv[1], 'r');
		pssm2fasta(fin, sys.stdout);
		fin.close();
	else:
		pssm2fasta(sys.stdin, sys.stdout);

main();



	


