#include "Timer.h"
using namespace std;

Timer::Timer() { this->reset(); }

#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>
double usec() {
	struct rusage use;
	getrusage(RUSAGE_SELF, &use);
	return use.ru_utime.tv_sec + use.ru_utime.tv_usec / 1000000.0;
}


#include <iostream>
#include <sstream>
#include <iomanip>
/** print time (given time in seconds) */
void printtime(ostream &out, double total) {

	const uint PREC = 3;	// significant digits when printing seconds only

	ostringstream oss;

	int days;
	int hours;
	int minutes;

	days = (int)total / 86400;
	total -= 86400*days;
	if (days) { oss << days << "d, "; }
	
	hours = (int)total / 3600;
	total -= 3600*hours;
	if (hours) { oss << hours << "h, "; }

	minutes = (int)total / 60;
	total -= 60*minutes;
	if (minutes) { oss << minutes << "m, "; }

	if (days || hours || minutes) {
		oss << (int)total << "s"; 
	} else { 
		oss << setprecision(PREC) << total << " seconds";
	}

	out << oss.str();

}

ostream& operator<<(ostream &out, const Timer &timer) { 

	printtime(out, timer.elapsed());
	return out;
}



