/**
	index-checked vector type 

	set CVECTOR_CHECK to false to turn this off for speed

*/


#ifndef CVECTOR_H
#define CVECTOR_H

#include <vector>
using namespace std;

#define CVECTOR_CHECK 0		// set to false to not check (keyword:  DEBUG)

#if CVECTOR_CHECK

	#include <iostream>
	#include <assert.h>

	template <typename T>
	class cvector : public vector<T> {

	  public:
		
		cvector() : vector<T>() { }
		cvector(uint sz) : vector<T>(sz) { }
	 
	 	// check beforehand
		T& operator[](uint index) {
			if (index >= vector<T>::size()) {
				cerr << "Error:  cvector size " <<  (vector<T>::size()) << " out-of-range[" << ((int)index) << "]." << endl;
				assert(index < vector<T>::size());
			}
			return (vector<T>::operator[](index));
		}
		
		const T& operator[](uint index) const {
			if (index >= vector<T>::size()) {
				cerr << "Error:  cvector size " <<  (vector<T>::size()) << " out-of-range[" << ((int)index) << "]." << endl;
				assert(index < vector<T>::size());
			}
			return (vector<T>::operator[](index));
		}

		// allow assignment from vector to cvector
		vector<T>& operator=(const vector<T> &v) { return vector<T>::operator=(v); }

	};

#else

	#define cvector vector	// unchecked:  same as vector

#endif	// #if CVECTOR_CHECK


#endif	// CVECTOR_H
