/** 

	utilities for pretty-printing matrices


**/


#ifndef GRID_H
#define GRID_H 0

#include <string>
#include <vector>
#include <sstream>
using namespace std;


/** DEPRECATED:  use `tostring'.  convert (ostream printable) data to a string */
template <typename _Printable>
string itos(const _Printable &i) { 
	ostringstream oss;
	oss << i;
	return oss.str();
}

/** return the length of the longest string */
template <typename _StrIterator>
int longest(_StrIterator begin, _StrIterator end) {
	int ans = -1;
	for (_StrIterator i=begin; i!=end; i++) { 
		if ( (int)(i->length()) > ans ) { ans = i->length(); }
	}
	return ans;
}

/** pad "s" with spaces in front so it's length is at least L */
string pad(const string &s, int L);

/** repeat "s" r times */
string repeat(const string &s, int r);

/** print special classification grid */
void print_classification_grid(int TP, int FP, int TN, int FN, ostream&);
void print_classification_grid(double TP, double FP, double TN, double FN, ostream&);

/** 
 *  pretty-print a 2-D grid of values
 *	justify = - 0 + for left center right
 */
void print_grid(const vector<vector<string> > &m, ostream &out, 
                const string &delim="\t", const string &rowsep="", int justify=1);

template <typename _Printable>
vector<vector<string> > printable2string(const vector<vector<_Printable> > &M) {

	vector<vector<string> > ans(M.size());

	for (int i=0; i<M.size(); i++) { 
		ans[i].resize(M[i].size());
		for (int j=0; j<M[i].size(); j++) { 
			ans[i][j] = itos(M[i][j]);
		}
	}
	return ans;
}

#endif	// GRID_H
