/*



*/


#include <iostream>
#include "PWM.h"
#include "genomic.h"
#include "Option.h"
#include "logscale.h"
#include "grid.h"
using namespace std;

string rand_dna(int L) { 
	
	string ans = "";
	for (int i=0; i<L; i++) { 
		ans = ans + string("acgt").substr( rand()%4 , 1 );
	}
	return ans;
}

void plant(PWM<double> &pwm, string &sequence, int location=-1) { 
	
	if (location < 0) { location = rand() % (sequence.length() - pwm.width()); }

	for (uint i=0; i<pwm.width(); i++) { 
		sequence[i+location] = pwm.sample(i);
	}
	return;
}


			

	


logscale likelihood(PWM<double> &pwm, string &sequence) { 

	const int L = sequence.length();
	const int w = pwm.width();	// shorthand

	logscale P = 0;
	logscale Pf = 0;
	logscale B = logscale::loginit(-2 * (L-w));

	for (int frame=0; frame<w; frame++) { 

		Pf = 0;
		int Z=0;

		for (int i=frame; i<=(L - w); i+=w) { 
		
			Pf += B * pwm.likelihood(sequence, false, i, i+w);
			Z++;
		}

		P += (Pf / (double)Z);
	}

	P /= w;

	return P;
}
		
void test_probabilities(string motif, double pc, int L, int N) {

	PWM<double> pwm(motif.length());
	pwm.fill(0);
	pwm.add(motif);
	pwm.pseudocount(pc);
	pwm.normalize();

	double pp=0;
	double np=0;

	for (int i=0; i<N; i++) { 

		string DNA = rand_dna(L);
		plant(pwm, DNA);
		logscale P = likelihood(pwm, DNA);
		logscale B = logscale::loginit(-2 * L);
		
		pp += (P / (P+B));
		
	}

	for (int i=0; i<N; i++) { 

		string DNA = rand_dna(L);
		logscale P = likelihood(pwm, DNA);
		logscale B;
		B.loginit(-2 * L);

		np += (P / (P+B));

	}

	cout << "P(PWM) | planted sequence (A. average) = " << (pp / N) << endl;
	cout << "P(PWM) | random  sequence (A. average) = " << (np / N) << endl;
	
	return;
}

void test_basic(const string motif, double pc) { 

	cout << "Test Basic PWM functions:" << endl;

	PWM<double> pwm(motif.length());

	cout << "Newly created " << pwm.width() << "-wide PWM:" << endl << pwm << endl;

	pwm.fill(0);
	pwm.add(motif);

	cout << "Original PWM:" << endl << pwm << endl;

	pwm.add(pwm);

	cout << "Add a copy of itself:" << endl << pwm << endl;

	pwm.pseudocount(pc);

	cout << "Pseudocount of " << pc << ":" << endl << pwm << endl;

	pwm.normalize();	
	
	cout << "Normalize:" << endl << pwm << endl;

	cout << "Likelihood of motif (\"" << motif << "\") is " << pwm.likelihood(motif) << endl;
	string MLE = pwm.mle();
	cout << "Likelihood of MLE (\"" << MLE << "\") is " << pwm.likelihood(MLE) << endl;
	cout << "Sample:  " << pwm.sample() << endl;
	cout << "Sample:  " << pwm.sample() << endl;
	cout << "Sample:  " << pwm.sample() << endl;
	cout << "Sample:  " << pwm.sample() << endl;
	cout << "Sample:  " << pwm.sample() << endl;
	cout << "Sample:  " << pwm.sample() << endl;
	cout << "Sample:  " << pwm.sample() << endl;
	cout << "Sample:  " << pwm.sample() << endl;
	cout << "Sample:  " << pwm.sample() << endl;
	cout << "Sample:  " << pwm.sample() << endl;

	PWM<double> pwm2;
	pwm2 = pwm;

	cout << "(Copy with operator=)" << endl << pwm << endl;

	pwm.fill(42);
	cout << "Fill with 42:" << endl << pwm << endl;

	pwm.fill(0);
	for (uint i=0; i<pwm.width(); i++) { pwm(i,0) = 1; }
	pwm.pseudocount(pc);
	pwm.normalize();

	cout << "A-heavy, normalized PWM of the same width:" << endl << pwm << endl;

	cout << "Likelihood of old MLE (\"" << MLE << "\") is " << pwm.likelihood(MLE) << endl;
	cout << "Likelihood of old MLE reverse complemented is " << pwm.likelihood(MLE,true) << endl;


}

int main(int argc, char **argv) { 

	string motif;
	double pc;
	
	OptionParser parser("Test PWM.h");
	parser.add("motif", 'm', &motif, "AGAG", "Sample motif (IUPAC Consensus)");
	parser.add("pc", 'p', &pc, 0.1, "Pseudocount");
	parser.parse(argc, argv);

	test_basic(motif, pc);

	return 0;

}



