/*
	Pretty-printable process timer
	
	Timer timer;
	...
	cout << "This program's been running for " << timer << endl;

*/

#ifndef TIMER_H
#define TIMER_H

#include <iostream>
using namespace std;

/**
 * Printing times, e.g.
 *
 *	Timer timer;
 *	dostuff();
 *	cout << "Elapsed time is: " << timer << endl;
 *
 *		-> "Elapsed time is 27m, 35s."
 *		-> "Elapsed time is 0.6231 seconds."
 */
void printtime(ostream&, long double seconds);

/** Get seconds (to the millionth) used by this process
	(officially since some arbitrary time in the past, but usually since the
	process start)
 */
double usec();


struct Timer { 
  private:
	double S;	// start offset
  public:
	Timer(); 
	inline void reset() { S = usec(); }
	inline double offset() const { return S; }
	inline double elapsed() const { return usec()-S; }
};

ostream& operator<<(ostream&, const Timer &timer);

#endif
