#include <string>
#include <vector>
#include <iostream>
#include <sstream>
#include <iomanip>
#include <fstream>
using namespace std;

#include <time.h>

#include "WSS.h"
#include "genomic.h"
#include "PWM.h"
#include "Option.h"

// g++ -o pwm2fasta pwm2fasta.cpp grid.cpp genomic.cpp

int main(unsigned int argc, char **argv);

PWM<double> pwm_parse(istream &in) {

	WSS wss;
	if (in.good()) { cin >> ws; }

	unsigned int base = 0;
	unsigned int site = 0;

	PWM<double> pwm;

	while (in.good()) {

		// must be a header row, shift up
		if (base == DNA_ABLEN) {
			for (unsigned int s=0; s<pwm.width(); s++) { 
			for (unsigned int b=0; b<(DNA_ABLEN-1); b++) { 
				pwm(s,b) = pwm(s,b+1);
			}}
			base = DNA_ABLEN - 1;
		}

		WSS wss;
		while (!wss.newline && cin.good()) { 

			string input;
			double d;
			cin >> input >> wss;

			if (input=="|") { continue; }
			if (input=="A") { continue; }
			if (input=="C") { continue; }
			if (input=="T") { continue; }
			if (input=="G") { continue; }
			if (input=="a") { continue; }
			if (input=="c") { continue; }
			if (input=="t") { continue; }
			if (input=="g") { continue; }

			istringstream iss(input);
			iss >> ws >> d >> ws;

			if (pwm.width() <= site) { pwm.resize(site+1); }
			
			pwm(site, base) = (double)d;

			site++;

		}

		site=0;
		base++;

	}

	pwm.normalize();	// 2006-09-05, could be ad-hoc user-defined
	return pwm;
}

int main(unsigned int argc, char **argv) { 

	unsigned int N;
	int seed;

	OptionParser parser("Sample from a PWM");
	parser.add("N", 'N', &N, 30, "Sample size");
	parser.add("seed", 's', &seed, -1, "PRNG seed");
	vector<string> args = parser.parse(argc, argv, " < PWM file");

	if (seed < 0) { 
		unsigned int x = time(NULL);
		srand(x);
	} else {
		srand((unsigned int)seed);
	}

	PWM<double> pwm;

	if (args.empty()) { 
		pwm = pwm_parse(cin);
	} else {
		ifstream fin(args[0].c_str());
		if (!fin) { 
			cerr << args[0] << "?" << endl;
			exit(-1);
		}
		pwm = pwm_parse(fin);
		fin.close();
	}

	for (unsigned int i=0; i<N; i++) { 
		
		cout << "> " << i << endl << pwm.sample() << endl;

	}

	return 0;

}

	
