#include "IOExample.h"
#include "fasta.h"



	 	
/** Read sequence from FASTA, calculate background using given MM */
IOExampleCode IOExample::read(istream &in, uint minimum, probability weight) {

	this->reweight(weight);

	// Assume FASTA format
	uint fasta_code;
	fasta_code = fasta_read(in, this->header, (this->dna));

	// Extract NAME from header (first full string after ">[white space]")
	istringstream iss(this->header);
	this->name_id = "";
	char c;
	iss.get(c);
	while (c < ' ') { iss.get(c); }	// read past any white space until c == first non-ws (should be '>')
	#if CRM_DEBUG
	if (c != '>') { cerr << "Warning (CRM Debug Mode):  IOExample::read:  Example Header \"" 
						 << this->header << "\" does not start with '>'." << endl; }
	#endif
	iss >> this->name_id;
	
	if (fasta_code != fasta_success) {
		#if CRM_DEBUG
		cerr << "IOExample::read(...):  "; 
		#endif
		cerr << "FASTA read error (" << fasta_message[fasta_code] << ")." << endl;
		return IOExREAD_ERROR;
	}

	if (this->dna.length() < minimum) { 

		#if CRM_DEBUG
		cerr << "IOExample::read(...):  "; 
		#endif
		cerr << endl << header << endl
			 << "Sequence too short (" << this->dna.length() << "):  " << this->header << endl;
		return IOExSHORT_SEQ;
	}

	return IOExSUCCESS;

} // read


IOExampleCode IOExample::set_background(const MM<probability> &mm) { 

	slv = mm.subsequence_likelihood(this->dna);

	#if CRM_DEBUG
	assert(this->slv.size() == this->dna.length() + 1);
	for (uint i=0; i<this->slv.size(); i++) { assert(!isnan(slv[i])); }
	#endif
	
	if (this->slv[this->dna.length()] <= 0) { 
		cerr << endl << "Warning:  P(Sequence|Background) falls to zero. ("
			 << header << ")" << endl;
		return IOExZERO_PROB;
	}
	
	return IOExSUCCESS;
}

IOExampleCode IOExample::set_background(const vector<probability> &d) { 
	
	this->slv.resize(this->dna.length() + 1);

	if (this->slv.size() != d.size()) {
		cerr << "Error:  Sequence '" << this->name() << "' background distribution "
			 << "incorrect size " << (this->slv.size()) << " != " << d.size() << endl;
		return IOExINCOMPATABLE;
	}
	
	std::copy(d.begin(), d.end(), this->slv.begin());

	return IOExSUCCESS;
}



/**** DEPRECATED
IOExampleCode IOExample::add_prior(istream &in, probability pc) {

	IOExampleCode code = IOExSUCCESS;

	this->mpp.resize( this->dna.length() );
	
	in >> ws;
	if (!in.good()) { 
		cerr << "Error reading prior distribution:  Empty file." 
			 << endl << "sequence:  " << header << endl; 
		return IOExREAD_ERROR;
	}
	
	///////probability sum = 0;

	// read
	for (uint i=0; i<mpp.size(); i++) { in >> mpp[i] >> ws; }
		////////probability number; in >> number >> ws; mpp[i] = number; sum += number; 




	return code;
}
*/

probability IOExample::prior(uint i, uint j) const { 
	if (mpp.size()) { 
		return mpp[i];	// 2006-03-16, using one representitive number
		//if (mpp[i]<=0) { return 0; }
		//return mpp[j] / mpp[i];
	} else {
		return 1;
	}
}

