/*

	This file contains the definition of various functions that explicitly
	constrain structure and/or parameters of the CRM model or the CRM learning
	task in general.

	Changes to the CRM model can be anything:  Force the order of binding sites
	(including learned ones), shrink the allowable distances, expand or reduce
	the binding site width, ...

	IMPORTANT:  The CRM algorithm will assume CRM models are normalized, so
	CRM::normalize should be called whenever this property may have changed.
	 
*/

#ifndef CUSTOM_H
#define CUSTOM_H

#include "CRM.h"


/**
 *
 * Called before running the E-M (Krogh et al, 1994) algorithm 
 */
void constrain_preconditions(CRM &crm, const vector<Example*> &training_data);



/**
 *
 * Called after each iteration of E-M (Krogh et al, 1994). 
 */
void constrain_per_iteration(CRM &crm, const vector<Example*> &training_data);

/**
 *
 * Called after the E-M (Krogh et al, 1994) algorithm is completed, just before
 * returning a solution (i.e. CRM object) from the `train(...)' function
 */
void constrain_finalize(CRM &crm, const vector<Example*> &training_data);


/** 
 * 
 * Called after the order probabilities are calculated.
 *
 * Alter the prior probabilities over binding site order.  (CRM object given as
 * a reference--cannot be changed).
 *
 * Parameter `order':  list of pairs of ( vector-of-binding-site-index-order ,
 * probability-of-that-order), where the order goes from left (upstream) to
 * right (downstream).
 *	
 * Typical use would be to set certain orderings to zero, then renormalize.
 *
 */
void constrain_order(list<pair<vector<uint>, probability> > &order, const CRM&);



#endif
