#include <vector>
#include <iostream>
using namespace std;

#include "fasta.h"

/* trim a line of FASTA sequence input */
void fasta_trim(string &s) { 
	
	uint p1,p2;

	for (p1=0; p1<s.length() && s[p1]<=' '; p1++);
	for (p2=s.length(); p2>=p1 && s[p2-1]<=' '; p2--);

	s = s.substr(p1, p2-p1);

	// special:  ends in '!' => expect continuation on next line
	if (s[s.length()-1] == '!') { s = s.substr(0,s.length()-1); }
}


/** skip past a fasta record */
fasta_code fasta_skip(istream &in) { 

	fasta_code ans = fasta_success;

	char p = '\0';
	char c;

	in >> ws;	// read "dead air"
	
	if (!in.good()) { return fasta_eof; }

	in.get(c);	// read leading '>' from header.

	if (c != '>') { ans = fasta_badheader; }
	
	while (in.good() && (c != '>' || p != '\n')) {
		p = c;
		in.get(c);
	}

	if (c == '>' && p == '\n') { in.putback(c); }	// replace line-leading '>', otherwise EOF
	
	return ans;
}


/** 
 *	Read a fasta record
 *
 *	Return:
 *		0 = success
 *		not 0 = not success
 *
 *	TODO:  make this a template that can read fasta-like files of any kind?
 *			(problem--FASTA files can contain ;'s and such that screw it up.
 */
fasta_code fasta_read(istream &in, string &header, string &sequence) { 

	fasta_code ans = fasta_success;	// default return value

	header = "";
	sequence = "";

	in >> ws;	// any "dead air"

	if (!in.good()) { return fasta_eof; }

	std::getline(in, header, '\n');	// read header line
	
	if (header[0] != '>') { ans = fasta_badheader; }	// keep reading anyway

	in >> ws;

	while (in.good()) { 

		in >> ws;

		char c = in.peek();

		if (c == '>') { break; }

		string dna = "";
		std::getline(in, dna, '\n');
		fasta_trim(dna);
		sequence += dna;

		in >> ws;

	}

	return ans;

}


